#include	"JokerPackage.h"
#include	<Carbon/Carbon.h>
#include	<string>
#include	<sys/stat.h>


/* FSpGetDirID returns the directory ID number for the directory
	pointed to by the file specification record *spec.  */
OSErr FSpGetDirID(FSSpec *spec, long *theDirID) {
	CInfoPBRec cat;
	OSErr err;
	BlockZero(&cat, sizeof(cat));
	cat.dirInfo.ioNamePtr = spec->name;
	cat.dirInfo.ioVRefNum = spec->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = spec->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) return err;
	if ((cat.dirInfo.ioFlAttrib & 16) == 0) return paramErr;
	*theDirID = cat.dirInfo.ioDrDirID;
	return noErr;
}

/* UpdateRelativeAliasFile updates the alias file located at aliasDest referring to the targetFile.
	relative path information is stored in the new file.  It is appropriate for targetFile to refer
	to either a file or a folder.  */
OSErr UpdateRelativeAliasFile(FSSpec *theAliasFile, FSSpec *targetFile, Boolean createIfNecessary, Boolean makeRelative) {
	CInfoPBRec cat;
	FInfo fndrInfo;
	AliasHandle theAlias;
	Boolean wasChanged;
	short rsrc;
	OSErr err;
	 	/* set up locals */
	rsrc = -1;
		/* set up the Finder information record */
	BlockZero(&fndrInfo, sizeof(fndrInfo));
	BlockZero(&cat, sizeof(cat));
	cat.dirInfo.ioNamePtr = targetFile->name;
	cat.dirInfo.ioVRefNum = targetFile->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = targetFile->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) goto bail;
	if ((cat.dirInfo.ioFlAttrib & 16) == 0) {	/* file alias */
		switch (cat.hFileInfo.ioFlFndrInfo.fdType) {
			case 'APPL': fndrInfo.fdType = kApplicationAliasType; break;
			case 'APPC': fndrInfo.fdType = kApplicationCPAliasType; break;
			case 'APPD': fndrInfo.fdType = kApplicationDAAliasType; break;
			default: fndrInfo.fdType = cat.hFileInfo.ioFlFndrInfo.fdType; break;
		}
		fndrInfo.fdCreator = cat.hFileInfo.ioFlFndrInfo.fdCreator;
	} else {
		fndrInfo.fdType = kContainerFolderAliasType;
		fndrInfo.fdCreator = 'MACS';
	}
	fndrInfo.fdFlags = kIsAlias;
	 	/* set the file information or the new file */
	err = FSpSetFInfo(theAliasFile, &fndrInfo);
	if ((err == fnfErr) && createIfNecessary) {
		FSpCreateResFile( theAliasFile, fndrInfo.fdCreator, fndrInfo.fdType, smSystemScript);
		if ((err = ResError()) != noErr) goto bail;
		err = FSpSetFInfo( theAliasFile, &fndrInfo);
		if (err != noErr) goto bail;
	} else if (err != noErr) goto bail;
	 	/* save the resource */
	rsrc = FSpOpenResFile(theAliasFile, fsRdWrPerm);
	if (rsrc == -1) { err = ResError(); goto bail; }
	UseResFile(rsrc);
	theAlias = (AliasHandle) Get1IndResource(rAliasType, 1);
	if (theAlias != NULL) {
		err = UpdateAlias( makeRelative ? theAliasFile : NULL, targetFile, theAlias, &wasChanged);
		if (err != noErr) goto bail;
		if (wasChanged)
			ChangedResource((Handle) theAlias);
	} else {
		err = NewAlias(makeRelative ? theAliasFile : NULL, targetFile, &theAlias);
		if (err != noErr) goto bail;
		AddResource((Handle) theAlias, rAliasType, 0, theAliasFile->name);
		if ((err = ResError()) != noErr) goto bail;
	}
	CloseResFile(rsrc);
	rsrc = -1;
		/* done */
	return noErr;
 bail:
	if (rsrc != -1) CloseResFile(rsrc);
	return err;
 }


/* -----------------------------------------------------------------------------
	MakePackage:
		The only required function of this file. Create a folder and label it
		as a package (aka bundle) the way your OS requires it, then create a
		file of same name inside that folder. If your OS does not support
		packages, just create a _folder_ with a file in it.
	
	TAKES:
		fPath	-	Path for the package (folder) to be created.
	
	GIVES:
		int		-	0 on success, anything else indicates an error.
	
	REVISIONS:
		2001-12-23	UK	Documented.
   -------------------------------------------------------------------------- */

int		MakePackage( const char* fPath )
{
	FSSpec				packFoldr;
    FSSpec				*packageFolder = &packFoldr;
    Boolean				constructChain = true;
	CInfoPBRec			cat;
	OSStatus			err;
	FSSpec				topAliasFile,
                        mainTargetFile,
                        chainAliasFile,
                        chainAliasFolder;
	long				packageFolderDirID,
                        chainAliasFolderDirID;
	Boolean				foundAlias,
                        targetIsFolder,
                        wasAliased;
	Str255				name,
                        folderName,
                        aliasName,
                        errstr;
    FSRef				vFolderRef,
                        vMainFileRef;
    Boolean				isFolder;
    std::string			mainFPath( fPath );
    size_t				vLastSlash;
    FILE*				vFile;
    
    // Append second copy of folder name to path so we have a path for the package's main file:
    vLastSlash = mainFPath.find_last_of( '/' );
    if( vLastSlash == -1 )
    {
        mainFPath += '/';
        mainFPath.append( fPath );
    }
    else
        mainFPath.append( mainFPath, vLastSlash );
    
    // Make folder and then main file in it:
    if( mkdir( fPath, S_IRWXU | S_IRWXG | S_IRWXO ) != 0 )
        return -1;
    vFile = fopen( mainFPath.c_str(), "w" );
    if( !vFile )
        return -1;	// Indicate an error.
    fclose( vFile );	// Create file and then close it again.
    
    // Now make FSSpec from path:
    err = FSPathMakeRef( (UInt8*) fPath, &vFolderRef, NULL );
	if (err != noErr) return err;
    err = FSGetCatalogInfo( &vFolderRef, kFSCatInfoNone, NULL, NULL, &packFoldr, NULL );
	if (err != noErr) return err;
    
    #if MAKE_MACOS_APP_BUNDLE
    // Now make FSSpec to main file:
    err = FSPathMakeRef( (UInt8*) mainFPath.c_str(), &vMainFileRef, NULL );
	if (err != noErr) return err;
    err = FSGetCatalogInfo( &vMainFileRef, kFSCatInfoNone, NULL, NULL, &mainTargetFile, NULL );
	if (err != noErr) return err;
    
		/* find out the folder's directory ID */
	BlockZero(&cat, sizeof(cat));
	cat.dirInfo.ioNamePtr = packageFolder->name;
	cat.dirInfo.ioVRefNum = packageFolder->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = packageFolder->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) return err;
	packageFolderDirID = cat.dirInfo.ioDrDirID;
    
    	/* Make top level alias for our package (absolute): */
    err = FSMakeFSSpec(packageFolder->vRefNum, packageFolderDirID, "\pMain Alias", &topAliasFile);
    if (err == fnfErr) err = noErr;
    if (err != noErr) return err;
    err = UpdateRelativeAliasFile(&topAliasFile, &mainTargetFile, true, false);	// NOT relative.
    if (err != noErr) return err;
    
		/* create a sub directory if needed */
	if (constructChain)
    {
			/* set up the folder FSSpec */
		err = FSMakeFSSpec(packageFolder->vRefNum, packageFolderDirID, "\pHackery", &chainAliasFolder);
		if (err == fnfErr) err = noErr;
		if (err != noErr) return err;
			/* find or create a sub directory for the indirect alias. */
		err = FSpGetDirID(&chainAliasFolder, &chainAliasFolderDirID);
		if (err != noErr)
			err = FSpDirCreate(&chainAliasFolder, smSystemScript, &chainAliasFolderDirID);
		if (err != noErr) {
			return err;
		}
			/* create a reference to the indirect alias file */
		err = FSMakeFSSpec(packageFolder->vRefNum, chainAliasFolderDirID, "\pMessenger", &chainAliasFile);
		if (err == fnfErr) err = noErr;
		if (err != noErr) return err;
			/* create an indirect alias file referencing the main target file */
		err = UpdateRelativeAliasFile(&chainAliasFile, &mainTargetFile, true, true);
		if (err != noErr) return err;
			/* create an alias file referring to the indirect file. */
		err = UpdateRelativeAliasFile(&topAliasFile, &chainAliasFile, false, true);
		if (err != noErr) return err;
	} else {
			/* update the alias file to a relative path */
		err = UpdateRelativeAliasFile(&topAliasFile, &mainTargetFile, false, true);
		if (err != noErr) return err;
	}
    #endif
    
		/* set the package flag */
	cat.dirInfo.ioNamePtr = packageFolder->name;
	cat.dirInfo.ioVRefNum = packageFolder->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = packageFolder->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) return err;
	cat.dirInfo.ioDrDirID = packageFolder->parID;
	cat.dirInfo.ioDrUsrWds.frFlags |= kHasBundle;
	err = PBSetCatInfoSync(&cat);
	if (err != noErr) return err;
    
	return noErr;
}