/*	***************************************************************************

	PROJECT:	Joker.mcp
	
	FILE:		JokerDummy.cpp
	
	PURPOSE:	Functions a real application using Joker will need to provide.
		
	COPYRIGHT:	(C) Copyright 2001 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2001-01-17	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"HyperTalk.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -
#pragma mark [Init/Kill]

/* --------------------------------------------------------------------------------
	RegisterObjectDescriptors:
		Register the syntax for your different object kinds that Joker should know
		about here.
		
		Called by the constructor of the HyperTalk class when the first instance
		of this class is instantiated.
	
	TAKES:
		-
		
	GIVES:
		-
	
	REVISIONS:
		2001-01-17	UK		Created.
   ----------------------------------------------------------------------------- */

void	HyperTalk::RegisterObjectDescriptors()
{
	/* Use RegisterObjectDescriptor with a pointer to a non-volatile TalkCommandEntry
		to register the syntax & instructions for your object descriptors. */
}



/* --------------------------------------------------------------------------------
	HyperAskInstruction:
		Display an edit field with a prompt and an optional default value.
	
	HI's FIELDS:
		0		-	prompt
		1		-	default answer (empty if none specified)
		Result	-	text entered by user
   ----------------------------------------------------------------------------- */

void	HyperAskInstruction( struct HyperInstruction& hi, ValueStack& s,
								TalkCallRecord& vCallRec )
{
	/* Bring up a dialog with the prompt here and write the default answer into
		the edit field. Set the value stored in the result field of the HI record
		to the text the user entered. */
	
	throw runtime_error( "The ask command is not implemented." );
}


/* --------------------------------------------------------------------------------
	HyperCreateObjectInstruction:
		Create a new object of specified name.
	
	HI's FIELDS:
		0		-	string identifying object type
		1		-	object name
		Result	-	*unused*
   ----------------------------------------------------------------------------- */

void	HyperCreateObjectInstruction( struct HyperInstruction& hi, ValueStack& s,
									TalkCallRecord& vCallRec )
{
	throw runtime_error( "The create command is not implemented." );
}


/* --------------------------------------------------------------------------------
	HyperBreakpointInstruction:
		The "debug checkpoint" command that lets you break into the debugger.
	
	HI's FIELDS:
		0		-	*unused*
		Result	-	*unused*
   ----------------------------------------------------------------------------- */

void	HyperBreakpointInstruction( struct HyperInstruction& hi, ValueStack& s,
											TalkCallRecord& vCallRec )
{
	HyperTalk*		vErrorScript;
	long			vLineNumber;
	
	s.GetErrorSource( vLineNumber, vErrorScript );
	std::cout << "\n\n *** BREAKPOINT *** Line:" << vLineNumber;
}


/* --------------------------------------------------------------------------------
	GetPropertyDefaultObject:
		Return the default object to use whenever a property is set without
		an object being specified.
		
		This could even allow setting the default object under script control
		to shorten long-winded property statements, i.e.:
		
		using cd btn 5 of cd 7 of stack "hard disk:folder:file" do
			set the name to "stack"
			if the icon is 1 then
				beep 1
			end if
		end using
		
		where it would set the name of the button and examine the icon of the
		button. Of course, there is no "using" control structure yet.
   ----------------------------------------------------------------------------- */

TalkEntity*		GetPropertyDefaultObject()
{
	throw runtime_error( "The default object for properties is missing." );
}



