/*	***************************************************************************

	PROJECT:	TalkBuiltInCommands
	
	FILE:		TalkBuiltInCommands.cpp
	
	PURPOSE:	Built-in commands with english-like syntax.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-07	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"HyperTalk.h"


#pragma mark -

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// These are the command entries describing the syntax of the commands:


#pragma mark Set
/* Set: This command assigns values to object properties. */
TalkCommandEntry	sSetCommandStructure =
{
	TALK_PARAM_IGNORE,			// Ignore instruction result.
	NULL,
	5,
	TOKEN_TYPE_SET_COMMAND,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperSetPropInstruction,	// set
	TOKEN_TYPE_THE_IDENTIFIER,	TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, NULL,						// [the]
	TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_IDENTIFIER,	1,	TALK_PARAM_IS_REQUIRED, NULL,						// <property>
	TOKEN_TYPE_OF_IDENTIFIER,	TALK_PARAM_TYPE_VALUE,		2,	TALK_PARAM_IS_OPTIONAL, NULL,						// [of <entity>]
	TOKEN_TYPE_TO_IDENTIFIER,	TALK_PARAM_TYPE_EXPRESSION,	3,	TALK_PARAM_IS_REQUIRED, NULL,						// to <expression>
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

/* IMPORTANT: The instructions below used to map to the operators, but since operators don't follow
	any refs (they always work on temporaries), I had to change this. Ignore the paragraphs in the
	comments that say this. */

#pragma mark Add
/* Add: Add maps to the "+" operator's instruction. Since this instruction takes two
	arguments and then stashes the result of processing them in its result, we have
	to re-map the instruction result to the same container as passed in param 2. */
TalkCommandEntry	sAddCommandStructure =
{
	2,						// Store instruction result in param 2.
	NULL,
	2,
	TOKEN_TYPE_ADD_COMMAND,		TALK_PARAM_TYPE_VALUE,		1,	TALK_PARAM_IS_REQUIRED, HyperAddCommand,	// add <value>
	TOKEN_TYPE_TO_IDENTIFIER,	TALK_PARAM_TYPE_CONTAINER,	2,	TALK_PARAM_IS_REQUIRED, NULL,				// to <container>
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Subtract
/* Subtract: Subtract maps to the "-" operator's instruction. Since this instruction
	takes two arguments and then stashes the result of processing them in its result,
	we have to re-map the instruction result to the same container as passed in param 2. */
TalkCommandEntry	sSubCommandStructure =
{
	1,						// Store instruction result in param 1 (of instruction, i.e. param 2 of "subtract").
	NULL,
	2,
	TOKEN_TYPE_SUBTRACT_COMMAND,	TALK_PARAM_TYPE_VALUE,		2,	TALK_PARAM_IS_REQUIRED, HyperSubCommand,	// subtract <value>
	TOKEN_TYPE_FROM_IDENTIFIER,		TALK_PARAM_TYPE_CONTAINER,	1,	TALK_PARAM_IS_REQUIRED, NULL,				// from <container>
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Multiply
/* Multiply: Multiply maps to the "*" operator's instruction. Since this instruction
	takes two arguments and then stashes the result of processing them in its result,
	we have to re-map the instruction result to the same container as passed in param 1. */
TalkCommandEntry	sMulCommandStructure =
{
	1,						// Store instruction result in param 1.
	NULL,
	2,
	TOKEN_TYPE_MULTIPLY_COMMAND,	TALK_PARAM_TYPE_CONTAINER,	1,	TALK_PARAM_IS_REQUIRED, HyperMulCommand,	// multiply <container>
	TOKEN_TYPE_BY_IDENTIFIER,		TALK_PARAM_TYPE_EXPRESSION,	2,	TALK_PARAM_IS_REQUIRED, NULL,				// by <expression>
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Divide
/* Divide: Divide maps to the "div" operator's instruction. Since this instruction
	takes two arguments and then stashes the result of processing them in its result,
	we have to re-map the instruction result to the same container as passed in param 1. */
TalkCommandEntry	sDivCommandStructure =
{
	1,						// Store instruction result in param 1.
	NULL,
	2,
	TOKEN_TYPE_DIVIDE_COMMAND,	TALK_PARAM_TYPE_CONTAINER,	1,	TALK_PARAM_IS_REQUIRED, HyperDivCommand,	// divide <container>
	TOKEN_TYPE_BY_IDENTIFIER,	TALK_PARAM_TYPE_EXPRESSION,	2,	TALK_PARAM_IS_REQUIRED, NULL,				// by <expression>
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Replace
/* Replace: This command replaces all occurrences of a pattern string inside another
	string through a third string. */
TalkCommandEntry	sReplaceCommandStructure =
{
	3,							// Store instruction result in param 3.
	NULL,
	3,
	TOKEN_TYPE_REPLACE_COMMAND,	TALK_PARAM_TYPE_VALUE,		1,	TALK_PARAM_IS_REQUIRED, HyperReplaceInstruction,	// replace <pattern>
	TOKEN_TYPE_WITH_IDENTIFIER,	TALK_PARAM_TYPE_VALUE,		2,	TALK_PARAM_IS_REQUIRED, NULL,						// with <newStr>
	TOKEN_TYPE_IN_IDENTIFIER,	TALK_PARAM_TYPE_CONTAINER,	3,	TALK_PARAM_IS_REQUIRED, NULL,						// in <text>
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Reply
/* reply:	This command is used on MacOS to do AppleEvent processing. If possible,
			other platforms should try to fake this for appropriate uses like open
			file events or CGIs, but otherwise they should just make this a dummy
			command that doesn't do anything. */
TalkCommandEntry	sReplyCommandStructure =
{
	TALK_PARAM_IGNORE,		// We don't care about result.
	NULL,
	5,
	TOKEN_TYPE_REPLY_COMMAND,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperReplyInstruction,	// reply
	TOKEN_TYPE_ERROR_IDENTIFIER,	TALK_PARAM_TYPE_QUALIFIER,	1,	TALK_PARAM_IS_OPTIONAL, NULL,					// [error]
	TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_EXPRESSION,	2,	TALK_PARAM_IS_REQUIRED, NULL,					// <expression>
	TOKEN_TYPE_WITH_IDENTIFIER,		TALK_PARAM_TYPE_QUALIFIER,	3,	TALK_PARAM_IS_OPTIONAL, NULL,					// [with]
	TOKEN_TYPE_KEYWORD_IDENTIFIER,	TALK_PARAM_TYPE_EXPRESSION,	4,	TALK_PARAM_IS_OPTIONAL, NULL,					// [keyword "aevt"]
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Pass
/* Pass: This causes the current handler to abort immediately and to pass the message's parameters
	to the next handler up the hierarchy. */
TalkCommandEntry	sPassCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	1,
	TOKEN_TYPE_PASS_COMMAND,	TALK_PARAM_TYPE_IDENTIFIER,	1,	TALK_PARAM_IS_REQUIRED,	HyperPassInstruction,		// Pass <name>
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};


#pragma mark Request
/* Request: This fetches some data from the current Apple Event and stores it in the local
	variable "it". */
TalkCommandEntry	sRequestCommandStructure =
{
	TALK_PARAM_IT,		// Stuff result in "it".
	NULL,
	4,
	TOKEN_TYPE_REQUEST_COMMAND,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperRequestInstruction,	// request
	TOKEN_TYPE_APPLEEVT_IDENTIFIER,	TALK_PARAM_TYPE_IDENTIFIER,	1,	TALK_PARAM_IS_REQUIRED, NULL,						// appleEvent <data|sender|id|class>
	TOKEN_TYPE_WITH_IDENTIFIER,		TALK_PARAM_TYPE_QUALIFIER,	2,	TALK_PARAM_IS_OPTIONAL, NULL,						// [with]
	TOKEN_TYPE_KEYWORD_IDENTIFIER,	TALK_PARAM_TYPE_EXPRESSION,	3,	TALK_PARAM_IS_OPTIONAL, NULL,						// [keyword "aevt"]
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Return
/* Return: This causes the current handler to abort and stores an optional return value
	in the handler result. */
TalkCommandEntry	sReturnCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	2,
	TOKEN_TYPE_RETURN_IDENTIFIER,	TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperReturnInstruction,	// return
	TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_EXPRESSION,	1,	TALK_PARAM_IS_OPTIONAL, NULL,					// [<string>]
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Exit
/* Return: This causes the current handler or script execution in general to abort in
    this thread. */
TalkCommandEntry	sExitCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	3,
	TOKEN_TYPE_EXIT_COMMAND,	TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperExitInstruction,	// exit
	TOKEN_TYPE_TO_IDENTIFIER,	TALK_PARAM_TYPE_QUALIFIER,	2,	TALK_PARAM_IS_OPTIONAL, NULL,					// to
	TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_IDENTIFIER,	1,	TALK_PARAM_IS_OPTIONAL, NULL,					// <handlerName>
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Ask
/* Ask: This Displays a dialog box with a text entry field and returns the text the user
	enters in the variable "it". */
TalkCommandEntry	sAskCommandStructure =
{
	TALK_PARAM_IT,		// Stuff result in "it".
	NULL,
	2,
	TOKEN_TYPE_ASK_COMMAND,			TALK_PARAM_TYPE_EXPRESSION,	1,	TALK_PARAM_IS_REQUIRED, HyperAskInstruction,	// ask <expression>
	TOKEN_TYPE_WITH_IDENTIFIER,		TALK_PARAM_TYPE_EXPRESSION,	2,	TALK_PARAM_IS_OPTIONAL, NULL,					// [with <defaultAnswer>]
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Define
/* define: Define a user property of an object that supports it. */
TalkCommandEntry	sDefineCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	4,
	TOKEN_TYPE_DEFINE_COMMAND,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperDefinePropInstruction,	// define
	TOKEN_TYPE_THE_IDENTIFIER,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, NULL,						// [the]
	TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_IDENTIFIER,	1,	TALK_PARAM_IS_REQUIRED, NULL,						// <propertyName>
	TOKEN_TYPE_OF_IDENTIFIER,		TALK_PARAM_TYPE_VALUE,		2,	TALK_PARAM_IS_REQUIRED, NULL,						// of <object>
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0,
    TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, 0
};

#pragma mark Undefine
/* undefine: Undefine a user property of an object that supports it. */
TalkCommandEntry	sUndefineCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	4,
	TOKEN_TYPE_DEFINE_COMMAND,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, HyperUndefinePropInstruction,	// undefine
	TOKEN_TYPE_THE_IDENTIFIER,		TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_OPTIONAL, NULL,							// [the]
	TOKEN_TYPE_INVALID,				TALK_PARAM_TYPE_IDENTIFIER,	1,	TALK_PARAM_IS_REQUIRED, NULL,							// <propertyName>
	TOKEN_TYPE_OF_IDENTIFIER,		TALK_PARAM_TYPE_VALUE,		2,	TALK_PARAM_IS_REQUIRED, NULL							// of <object>
};

#pragma mark Do
/* do: run a list of HyperTalk statements. */
TalkCommandEntry	sDoCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	1,
	TOKEN_TYPE_DO_COMMAND,	TALK_PARAM_TYPE_EXPRESSION,		1,	TALK_PARAM_IS_REQUIRED, HyperDoInstruction			// do <script>				// <objectName>
};

#pragma mark Debug
/* debug: do debugging stuff like breakpoints or setting hidden flags in the engine.
	debug alone makes no sense and will cause an error. Debug checkpoint causes a breakpoint.
	HC also has debug quickdraw and others that could be added here. */
TalkCommandEntry	sDebugCommandStructure =
{
	TALK_PARAM_IGNORE,		// Don't care about result.
	NULL,
	2,
	TOKEN_TYPE_DEBUG_COMMAND,			TALK_PARAM_TYPE_INVALID,	0,	TALK_PARAM_IS_REQUIRED, NULL,						// debug
	TOKEN_TYPE_CHECKPOINT_IDENTIFIER,	TALK_PARAM_TYPE_INVALID,	1,	TALK_PARAM_IS_OPTIONAL, HyperBreakpointInstruction,	// [checkpoint]
};

#pragma mark Delete
/* Delete: Delete a range of text, an array entry or an object. */
TalkCommandEntry	sDeleteCommandStructure =
{
	TALK_PARAM_IGNORE,
	NULL,
	2,
	TOKEN_TYPE_DELETE_COMMAND,	TALK_PARAM_TYPE_CONTAINER,	1,	TALK_PARAM_IS_REQUIRED, HyperDeleteCommand	// delete <object>
};

#pragma mark -
#pragma mark [Init/Kill]

/* --------------------------------------------------------------------------------
	RegisterBuiltInCommands:
		Registers all built-in commands we know about.
	
	TAKES:
		-
		
	GIVES:
		-
	
	REVISIONS:
		2000-11-07	UK		Created.
   ----------------------------------------------------------------------------- */

void	HyperTalk::RegisterBuiltInCommands()
{
	HyperTalk::RegisterBuiltInCommand( &sSetCommandStructure );			// set.
	HyperTalk::RegisterBuiltInCommand( &sAddCommandStructure );			// add.
	HyperTalk::RegisterBuiltInCommand( &sSubCommandStructure );			// subtract.
	HyperTalk::RegisterBuiltInCommand( &sMulCommandStructure );			// multiply.
	HyperTalk::RegisterBuiltInCommand( &sDivCommandStructure );			// divide.
	HyperTalk::RegisterBuiltInCommand( &sReplaceCommandStructure );		// replace.
	HyperTalk::RegisterBuiltInCommand( &sReplyCommandStructure );		// reply.
	HyperTalk::RegisterBuiltInCommand( &sPassCommandStructure );		// pass.
	HyperTalk::RegisterBuiltInCommand( &sRequestCommandStructure );		// request.
	HyperTalk::RegisterBuiltInCommand( &sReturnCommandStructure );		// return.
	HyperTalk::RegisterBuiltInCommand( &sAskCommandStructure );			// ask.
	HyperTalk::RegisterBuiltInCommand( &sDefineCommandStructure );		// define.
	HyperTalk::RegisterBuiltInCommand( &sUndefineCommandStructure );	// undefine.
	HyperTalk::RegisterBuiltInCommand( &sDoCommandStructure );			// do.
	HyperTalk::RegisterBuiltInCommand( &sDebugCommandStructure );		// debug.
	HyperTalk::RegisterBuiltInCommand( &sExitCommandStructure );		// exit.
	HyperTalk::RegisterBuiltInCommand( &sDeleteCommandStructure );		// delete.
}


