/*	***************************************************************************

	PROJECT:	MaxJoker.mcp
	
	FILE:		TalkExtendableEntity.cpp
	
	PURPOSE:	Entity that knows how to handle user properties.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-21	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"TalkExtendableEntity.h"
#include	"TalkVarValue.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -
#pragma mark [Init/Kill]

/* --------------------------------------------------------------------------------
	* CONSTRUCTOR:
		Do some initialization.
	
	TAKES:
		-
		
	GIVES:
		-
	
	REVISIONS:
		2000-11-21	UK		Created.
   ----------------------------------------------------------------------------- */

TalkExtendableEntity::TalkExtendableEntity()
: TalkEntity()
{
	// Do your stuff here!
}


/* --------------------------------------------------------------------------------
	* DESTRUCTOR:
		Do some cleanup.
	
	REVISIONS:
		2000-11-21	UK		Created.
   ----------------------------------------------------------------------------- */

TalkExtendableEntity::~TalkExtendableEntity()
{
	KillUserProperties();
}


#pragma mark [Class Methods]

/* --------------------------------------------------------------------------------
	GetPropertyValue:
		Retrieve a user property from this object.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		2000-11-21	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkExtendableEntity::GetPropertyValue( const TextMunger& pName,
												TalkValue& outValue ) const
{
	TalkValueList::const_iterator		vIterator;
	
	vIterator = mUserProperties.find( pName );
	if( vIterator != mUserProperties.end() )	// Found this property.
		(*vIterator).second->CopyValueTo( outValue );	// Don't follow any refs, outValue is a temp.
	else	// Didn't find it:
		throw runtime_error( "No such property." );
}


/* --------------------------------------------------------------------------------
	SetPropertyValue:
		Change a user property of this object.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		2000-11-21	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkExtendableEntity::SetPropertyValue( const TextMunger& pName,
												const TalkValue& inValue )
{
	TalkValueList::iterator		vIterator;
	
	vIterator = mUserProperties.find( pName );
	if( vIterator != mUserProperties.end() )	// Found this property.
		inValue.CopyValueTo( *((*vIterator).second), true, true );	// Follow refs.
	else	// Didn't find it:
		throw runtime_error( "No such property." );
}


/* --------------------------------------------------------------------------------
	DefineProperty:
		Add a user property to this object.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		2000-11-25	UK		Changed to not error on existing user properties.
		2000-11-21	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkExtendableEntity::DefineProperty( const TextMunger& pName )
{
	TalkValueList::iterator		vIterator;
	
	vIterator = mUserProperties.find( pName );
	if( vIterator == mUserProperties.end() )	// Doesn't exist yet?
		mUserProperties[pName] = new TalkVarValue( TextMunger("") );	// Make new one.
}


/* --------------------------------------------------------------------------------
	UndefineProperty:
		Remove a user property from this object.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		2000-11-21	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkExtendableEntity::UndefineProperty( const TextMunger& pName )
{
	TalkValueList::iterator		vIterator;
	
	vIterator = mUserProperties.find( pName );
	if( vIterator != mUserProperties.end() )
	{
		delete (*vIterator).second;			// Kill its value.
		mUserProperties.erase( vIterator );	// Remove entry in list.
	}
	else
		throw runtime_error( "No such user property." );
}


/* --------------------------------------------------------------------------------
	GetPropertyArray:
		Return a TalkValue that is an array of property values with the property
		names as the indexes.
	
	TAKES:
		-
	
	GIVES:
		TalkValue*	-	A pointer to a TalkVarValue object containing the list.
						You are responsible for disposing of this.
	
	REVISIONS:
		2001-07-18	UK		Created.
   ----------------------------------------------------------------------------- */

TalkValue*	TalkExtendableEntity::GetPropertyArray()
{
	TalkValueList::iterator		vIterator;
	TalkVarValue*				vValue = new TalkVarValue(0L);
	TalkValue*					vElement;
	
	for( vIterator = mUserProperties.begin(); vIterator != mUserProperties.end(); vIterator++ )
	{
		vValue->GetListEntry( vElement, vIterator->first );
		vIterator->second->CopyValueTo( *vElement );
	}
	
	return vValue;
}


/* --------------------------------------------------------------------------------
	GetPropertyNameArray:
		Return an array containing the names of all properties in this object.
		The keys are integers from 1 to n.
	
	TAKES:
		-
	
	GIVES:
		TalkValue*	-	A TalkVarValue object containing the array. You are
						responsible for disposing of this.
	
	REVISIONS:
		2001-07-18	UK		Created.
   ----------------------------------------------------------------------------- */

TalkValue*	TalkExtendableEntity::GetPropertyNameArray()
{
	TalkValueList::iterator		vIterator;
	TalkVarValue*				vValue = new TalkVarValue(0L);
	TalkValue*					vElement;
	ValueStorage				vStor;
	char						vStr[20];
	long						x = 0;
	
	for( vIterator = mUserProperties.begin(); vIterator != mUserProperties.end(); vIterator++ )
	{
		sprintf( vStr, "%ld", ++x );
		TextMunger		vIndex( vStr );
		vValue->GetListEntry( vElement, vIndex );
		vStor.textType = new TextMunger( vIterator->first );
        TexMunAPtr	vKiller( vStor.textType );
		vElement->SetValue( vStor, VALUE_TYPE_TEXT );
	}
	
	return vValue;
}


/* --------------------------------------------------------------------------------
	SetPropertyArray:
		Set the user properties of this object to have the names of the keys in
		an array and the values of the array elements.
	
	TAKES:
		vValue	-	An array of [property name] = <property value> elements
					like it's returned by GetPropertyArray(). The values in this
					array are COPIED to the user properties list.
	
	GIVES:
		-
	
	REVISIONS:
		2001-07-18	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkExtendableEntity::SetPropertyArray( const TalkValue& vValue )
{
	KillUserProperties();	// First get rid of any user properties this obj may have had.
	vValue.CopyListTo( mUserProperties );
}


/* --------------------------------------------------------------------------------
	KillUserProperties:
		Dispose of all user properties this object has and empty the list.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		2001-07-18	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkExtendableEntity::KillUserProperties()
{
	TalkValueList::iterator		vIterator;
	
	for( vIterator = mUserProperties.begin(); vIterator != mUserProperties.end(); vIterator++ )
		delete vIterator->second;
	
	mUserProperties.clear();
}




