/*	***************************************************************************

	PROJECT:	TalkGlobalsList
	
	FILE:		TalkGlobalsList.cpp
	
	PURPOSE:	Map variable names to their locations on the stack.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"TalkGlobalsList.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -

/* --------------------------------------------------------------------------------
	 DESTRUCTOR:
		Dispose of all variable values.
	
	REVISIONS:
		1999-12-29	UK		Created.
   ----------------------------------------------------------------------------- */

TalkGlobalsList::~TalkGlobalsList()
{
	iterator		vIterator;
	
	// Loop over all globals:
	for( vIterator = begin(); vIterator != end(); vIterator++ )
	{
		delete (*vIterator).second;	// Dispose of this global's value.
	}
}

/* --------------------------------------------------------------------------------
	GetVarByName:
		Retrieve a pointer to the specified global's value. This optionally
		creates a global of requested name.
	
	TAKES:
		varName		-	Name of global to look for.
		doCreate 	-	Create global if none found?
	
	GIVES:
		TalkValue*	-	Pointer to value used by the global. This belongs to the
						global! Don't dispose of it!
	
	REVISIONS:
		1999-12-29	UK		Created.
   ----------------------------------------------------------------------------- */

TalkValue*	TalkGlobalsList::GetVarByName( TextMunger& varName, bool doCreate )
{
	iterator 		vIterator;
	
	vIterator = find( varName );
	if( vIterator == end() )
	{
		if( doCreate )
		{
			TalkVarValue*		vValue;
			
			vValue = new TalkVarValue( new TextMunger( "" ) );
			
			(*this)[varName] = vValue;
			return( vValue );
		}
		else
			return NULL;
	}
	else
		return (*vIterator).second;
}













