/*	***************************************************************************

	PROJECT:	TalkInternalVarList
	
	FILE:		TalkInternalVarList.cpp
	
	PURPOSE:	Array of stack indices to our internal variables. Internal
				variables are sort of like temporary variables in that they
				are used internally by the compiler to aid in generating
				complex expressions. However, internal variables can be
				requested and released individually and persist beyond
				the scope of a single command. That's why they are ideal
				for variables like loop counters, which are used only
				inside the loop that uses them, and can then be re-used by
				the compiler for other purposes.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"TalkInternalVarList.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -

/* --------------------------------------------------------------------------------
	GetNewVariable:
		Get the next unused internal var's stack location, or if we have none
		create a new one, add it to our list of internal vars and return its
		stack location.
	
	TAKES:
		-
	
	GIVES:
		ValStackLocation	-	The index of the variable on the stack.
	
	REVISIONS:
		2001-01-16	UK		Created.
   ----------------------------------------------------------------------------- */

ValStackLocation	TalkInternalVarList::GetNewVariable()
{
	ValStackLocation		vResult = 0;
	
	if( mUnusedVars.size() == 0 )	// Are we out of unused ones?
	{
		// Register a new variable (our internal var) from stack:
		mStackVarCount++;	// mStackVarCount is a reference!!!
		
		vResult = mStackVarCount -1;	// Index is zero-based.
		mUsedVars.push_back( vResult );	// Add new var's index to our list of used internal vars.
	}
	else
	{
		// Move entry of unused variable back into the "used" list.
		
		vResult = mUnusedVars.back();
		mUnusedVars.pop_back();
		mUsedVars.push_back( vResult );
	}
	
	return vResult;
}


/* --------------------------------------------------------------------------------
	ReleaseVariable:
		Find an internal variable in our list of internal variables and move it
		to our list of unused internal variables so it can be re-used. Call this
		when you're done using an internal variable.
	
	TAKES:
		ValStackLocation	-	The index of the variable on the stack.
	
	GIVES:
		-
	
	REVISIONS:
		2001-01-16	UK		Created.
   ----------------------------------------------------------------------------- */

void	TalkInternalVarList::ReleaseVariable( ValStackLocation n )
{
	vector<ValStackLocation>::iterator	vItty;
	
	for( vItty = mUsedVars.begin(); vItty != mUsedVars.end(); vItty++ )
	{
		if( (*vItty) == n )
		{
			mUsedVars.erase( vItty );
			mUnusedVars.push_back( n );
			break;
		}
	}
}













