/*	***************************************************************************

	PROJECT:	TalkInternalVarList
	
	FILE:		TalkInternalVarList.h
	
	PURPOSE:	Array of stack indices to our internal variables. Internal
				variables are sort of like temporary variables in that they
				are used internally by the compiler to aid in generating
				complex expressions. However, internal variables can be
				requested and released individually and persist beyond
				the scope of a single command. That's why they are ideal
				for variables like loop counters, which are used only
				inside the loop that uses them, and can then be re-used by
				the compiler for other purposes.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#ifndef TALKINTERNALVARLIST_H
#define TALKINTERNALVARLIST

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"HyperTalk.h"
#include	<vector>


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	TalkInternalVarList
{
protected:
	vector<ValStackLocation>	mUnusedVars;
	vector<ValStackLocation>	mUsedVars;
	ValStackLocation&			mStackVarCount;

public:
			TalkInternalVarList( ValStackLocation& vs ) : mStackVarCount(vs) {};
	
	ValStackLocation	GetNewVariable();
	void				ReleaseVariable( ValStackLocation vsl );
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */











#endif /*TALKINTERNALVARLIST_H*/

