/*	***************************************************************************

	PROJECT:	TalkMemLocation
	
	FILE:		TalkMemLocation.h
	
	PURPOSE:	A memory address with relative addressing that refers to an
				entry on the stack, or contains an immediate value.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-02-14	UK		Created.
				
	************************************************************************ */

#ifndef TALKMEMLOCATION_H
#define TALKMEMLOCATION_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	"TalkValue.h"
#include	"ValueStack.h"


#pragma mark [Constants]

/* --------------------------------------------------------------------------------
	Constants:
   ----------------------------------------------------------------------------- */

enum
{
// Index of Accu in array of variables:
	MEM_INDEX_ACCU				= 0
};

// MemLocation types:
typedef enum MemLocationEnum
{
	MEM_LOCATION_TYPE_INVALID = 0,		// Invalid -- Used to identify cases where we don't want return values from functions.
	MEM_LOCATION_TYPE_IMMEDIATE,		// Constant.
	MEM_LOCATION_TYPE_STACK,			// Temporary or variable on the stack.
	MEM_LOCATION_TYPE_LONG				// A long -- used for pushing param count onto stack.
} MemLocationEnum;


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

// An immediate or stack variable:
class	TalkMemLocation
{
public:
	MemLocationEnum		mType;
	union
	{
		TalkValue*			mValue;		// mType == MEM_LOCATION_TYPE_IMMEDIATE: Pointer to actual value.
		ValStackLocation	mLocation;	// mType == MEM_LOCATION_TYPE_STACK: Offset into stack.
		long				mLong;		// mType == MEM_LOCATION_TYPE_LONG: The number stored here.
	};
	
	void			GetValue( ValueStorage& outValue, ValueStack& s, unsigned long desiredType );
	void			SetValue( ValueStorage& inValue, ValueStack& s, unsigned long providedType, bool followRefs = false );
	void			GetValue( TalkValue* &outValue, ValueStack& s );
	void			GetListEntry( TalkValue* &returnValue, ValueStack& s, TextMunger& index );
	void			CopyValueTo( TalkValue& vValue, ValueStack &s, bool followSrcRefs = false, bool followDstRefs = false );
	unsigned long	GetAvailableTypes( ValueStack &s );
};

#endif /* TALKMEMLOCATION_H */