/* =============================================================================
	PROJECT:	Joker
	FILE:		TalkScriptBlock.cpp
	
    COPYRIGHT:	Copyright (c) 2001 M. Uli Kusterer. All rights reserved.
    
    REVISIONS:
        Thu Sep 27 2001	witness	Created.
   ========================================================================== */

/* -----------------------------------------------------------------------------
    Headers:
   -------------------------------------------------------------------------- */

#include "HyperTalk.h"


/* -----------------------------------------------------------------------------
    Parse:
        Override this function for your own kind of blocks. By default this
        just skips the current line. An object of this non-subclassed type is
        used whenever no other block wants to handle a line.
    
    TAKES:
        vScript		-	The script object we're working on.
        iterator	-	An iterator pointing into vScript's token list and
                        which points at the token that caused the parser to
                        delegate parsing to this object and not another one.
                        E.g. the "on" or "function" identifier that indicates
                        the start of a command or function handler.
        vCurrLineNum -	This variable contains the line number used for
                        displaying debugging information. Whenever you encounter
                        a TOKEN_TYPE_NEWLINE token, you should increase this by
                        1.
    
    REVISIONS:
        Thu Sep 27 2001	witness	Created.
   -------------------------------------------------------------------------- */

void	TalkScriptBlock::Parse( HyperTalk& vScript, HTLIterator& iterator,
                                long &vCurrLineNum )
{
    HyperToken*		vToken = *iterator;
    
    while( vToken->GetType() != TOKEN_TYPE_NEWLINE )
    {
        ++iterator;
        if( iterator == vScript.GetTokenList().end() )
            return;
        
        vToken = (*iterator);
    }
    vCurrLineNum++;
}


void	TalkFcnHandlerBlock::Parse( HyperTalk& vScript, HTLIterator& iterator,
                                    long &vCurrLineNum )
{
    vScript.ParseHandler( iterator, true, vCurrLineNum );
}


void	TalkCmdHandlerBlock::Parse( HyperTalk& vScript, HTLIterator& iterator,
                                    long &vCurrLineNum )
{
    vScript.ParseHandler( iterator, false, vCurrLineNum );
}

