/*	***************************************************************************

	PROJECT:	TalkTempVarList
	
	FILE:		TalkTempVarList.h
	
	PURPOSE:	Array of indices of our temp variables +pointer to first unused.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#ifndef TALKTEMPVARLIST_H
#define TALKTEMPVARLIST_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"HyperTalk.h"
#include	<vector>


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	TalkTempVarList : public vector<ValStackLocation>
{
protected:
	size_type			mFirstUnused;
	ValStackLocation&	mStackVarCount;

public:
			TalkTempVarList( ValStackLocation& vs ) : vector<ValStackLocation>(), mFirstUnused(0), mStackVarCount(vs) {};
	
	void				ResetUnusedPointer();
	ValStackLocation	GetNewTemp();
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */











#endif /*TALKTEMPVARLIST_H*/

