/*	***************************************************************************

	PROJECT:	TalkVarNameList
	
	FILE:		TalkVarNameList.cpp
	
	PURPOSE:	Map variable names to their locations on the stack.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"TalkVarNameList.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -

/* --------------------------------------------------------------------------------
	GetVarByName:
		Retrieve the location on the stack of a variable of specified name. If
		there is no variable of this name, this optionally creates it or returns
		MEM_INDEX_ACCU.
	
	TAKES:
		varName	-	Name of variable to look for.
		doCreate -	Create variable if none found?
	
	GIVES:
		-
	
	REVISIONS:
		1999-12-01	UK		Created.
   ----------------------------------------------------------------------------- */

ValStackLocation	TalkVarNameList::GetVarByName( const TextMunger& varName, bool doCreate )
{
	iterator vIterator;
	
	varName.RecalcHash();
	
	vIterator = find( varName );
	if( vIterator == end() )
	{
		if( doCreate )
		{
			(*this)[varName] = mStackVarCount;	// Remember new var's loc with its name.
			return( mStackVarCount++ );	// Return var's loc and increase number of vars needed (reference!).
		}
		else
			return MEM_INDEX_ACCU;
	}
	else
		return (*vIterator).second;
}


/* --------------------------------------------------------------------------------
	GetInternalVariable:
		Get a variable with a random name that the user can't enter. This is used
		by the interpreter for variables like loop counters.
		
		A smarter version of this would probably also keep a list of no longer
		used internal variables and reuse those.
	
	TAKES:
		-
	
	GIVES:
		ValStackLocation	-	stack location of the variable.
	
	REVISIONS:
		2001-01-16	UK		Created.
   ----------------------------------------------------------------------------- */

ValStackLocation	TalkVarNameList::GetInternalVariable()
{
	TextMunger		vVarName( "" );
	
	/* Find a unique variable name:
		The name consists of spaces, which the user can't enter as
		a variable name. */
	do
	{
		vVarName.SetOffset( vVarName.GetOffset() );
		vVarName.Insert<char>( ' ' );
		vVarName.RecalcHash();
	}
	while( find(vVarName) != end() );
	
	return GetVarByName( vVarName, true );	// Actually create a variable of that name.
}













