/*	***************************************************************************

	PROJECT:	TalkVarNameList
	
	FILE:		TalkVarNameList.h
	
	PURPOSE:	Map variable names to their locations on the stack.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"HyperTalk.h"
#include	"TextMunger.h"
#include	<map>


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	TalkVarNameList : public map<TextMunger,ValStackLocation>
{
protected:
	ValStackLocation&	mStackVarCount;

public:
			TalkVarNameList( ValStackLocation& localVarCount ) : map<TextMunger,ValStackLocation>(), mStackVarCount(localVarCount) {};
	
	ValStackLocation	GetVarByName( const TextMunger& varName, bool doCreate = false );
	ValStackLocation	GetInternalVariable();
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */













