/*	***************************************************************************

	PROJECT:	XSmartPointer
	
	FILE:		XSmartPointer.h
	
	PURPOSE:	Handle pointers in a smart way. This throws an exception
				whenever someone tries to access a NULL pointer.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-05-06	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]
#pragma once

#ifndef X_SMART_POINTER_H
#define X_SMART_POINTER_H

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	<stdexcept>
#include	<string>

using namespace std;


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	XSmartPointer
{
protected:
	char*			mPointer;		// The actual pointer.

public:
	XSmartPointer()	: mPointer(NULL) {};
	XSmartPointer( char* vPtr )	: mPointer(vPtr) {};

	operator char* ()
	{
		if( mPointer == NULL )
		{
			throw runtime_error( "WARNING: Accessing NULL pointer!" );
			return NULL;
		} else return mPointer;
	};
	operator long ()
	{
		if( mPointer == NULL )
		{
			throw runtime_error( "WARNING: Accessing NULL pointer!" );
			return 0L;
		} else return (long) mPointer;
	};
	char operator* ()
	{
		if( mPointer == NULL )
		{
			throw runtime_error( "WARNING: Accessing NULL pointer!" );
			return NULL;
		} else return *mPointer;
	};
	char operator-> ()
	{
		if( mPointer == NULL )
		{
			throw runtime_error( "WARNING: Accessing NULL pointer!" );
			return NULL;
		} else return *mPointer;
	};
	bool operator==(const XSmartPointer& rhs)	{ return mPointer == rhs.mPointer; };
	bool operator==(const long& rhs)			{ return ((long)mPointer) == rhs; };
	bool operator!=(const XSmartPointer& rhs)	{ return mPointer != rhs.mPointer; };
	bool operator!=(const long& rhs)			{ return ((long)mPointer) != rhs; };
	XSmartPointer& operator=(const XSmartPointer& val)		{ mPointer = val.mPointer; return *this; };
	XSmartPointer& operator=(char* val)						{ mPointer = val; return *this; };
};


#endif /*X_SMART_POINTER_H*/










