/*	***************************************************************************

	PROJECT:	missinghandler_error
	
	FILE:		missinghandler_error.cpp
	
	PURPOSE:	Exception thrown when a handler can't be found.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-07	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"missinghandler_error.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -
#pragma mark [Init/Kill]

/* --------------------------------------------------------------------------------
	 CONSTRUCTOR:
		Do some initialization.
	
	TAKES:
		what_arg	-	Error message to display.
		handName	-	Name of handler that couldn't be found.
		
	GIVES:
		-
	
	REVISIONS:
		2000-11-07	UK		Created.
   ----------------------------------------------------------------------------- */

missinghandler_error::missinghandler_error( const string& what_arg,
											const TextMunger& handName )
	: std::runtime_error( what_arg ),
	mHandlerName( handName )
{
	// Do your stuff here!
}


/* --------------------------------------------------------------------------------
	 DESTRUCTOR:
		Do some cleanup.
	
	REVISIONS:
		2000-11-07	UK		Created.
   ----------------------------------------------------------------------------- */

missinghandler_error::~missinghandler_error()
{
	// Do your stuff here!
}












