/*	

	PROJECT:	parse_error
	
	FILE:		parse_error.cpp
	
	PURPOSE:	Error that reports line & character where error occurred.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-11	UK		Created.
				
	 */

#pragma mark [Headers]

/* 
	Headers:
    */

#include	"parse_error.h"
#include	<cstring>

using namespace std;


#pragma mark [Globals]

/* 
	Globals/Static Variables:
    */

// Put these li'l critters here.


#pragma mark -
#pragma mark [Init/Kill]

/* 
	 CONSTRUCTOR:
		Do some initialization.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		1999-12-11	UK		Created.
    */

parse_error::parse_error( const std::string& what_ar, std::size_t startCh,
							std::size_t endCh )
	: std::runtime_error( what_ar )
{
	mStartChar = startCh;
	mEndChar = endCh;
}


/* 
	what:
		Make sure we return the enhanced error message.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		1999-12-11	UK		Created.
    */

char*	parse_error::what() const
{
	char		vNumStr[512];
	
	strncpy( mErrorString, runtime_error::what(), 511 );
	strncat( mErrorString, "\r\r", 511 );
	sprintf( vNumStr, "(Character %ld to %ld)", GetStartChar(), GetEndChar() );
	strncat( mErrorString, vNumStr, 511 );
	
	return mErrorString;
}


/* 
	 DESTRUCTOR:
		Do some cleanup.
	
	REVISIONS:
		1999-12-11	UK		Created.
    */

parse_error::~parse_error()
{
	// Do your stuff here!
}













