/*	

	PROJECT:	parse_error
	
	FILE:		parse_error.h
	
	PURPOSE:	Error that reports line & character where error occurred.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-11	UK		Created.
				
	 */

#pragma mark [Headers]

/* 
	Headers:
    */
   
#include	<stdexcept>
#include	<string>


#pragma mark [Class Declaration]

/* 
	Class declaration:
    */

class	parse_error : public std::runtime_error
{
protected:
	std::size_t		mStartChar;
	std::size_t		mEndChar;
	mutable char	mErrorString[512];

public:
			parse_error( const std::string& what_ar, std::size_t startCh, std::size_t endCh );
	virtual	~parse_error();
	
	virtual char*	what() const;
	std::size_t	GetStartChar() const	{ return mStartChar; };
	std::size_t	GetEndChar() const		{ return mEndChar; };
};


#pragma mark [Prototypes]

/* 
	Prototypes:
    */













