// If this constant is defined, we're being compiled for a Mac:
#define		JOKER_MACINTOSH		1

/* Set this to true to output lots of additional
	debugging info during runtime. */
#define		JOKER_DEBUG		false

// Displays info about this version of Joker:
#define JOKER_DISPLAY_VERSION		false

#if JOKER_DEBUG
	// Dumps the stack to the console before and after every function call:
	#define	JOKER_STACK_TRACES			true
	// Displays a mini-debugger that lets you step through the code, dump stack states etc.
	#define	JOKER_MINI_DEBUGGER			false
	// Outputs chunk types and ranges during chunk operations:
	#define JOKER_CHUNK_TYPES			false
	// Dumps the compiled instructions:
	#define JOKER_DUMP_INSTRUCTIONS		true
	// Dumps a notification whenever one line has been executed:
	#define	JOKER_DEBUG_OUTPUT_LINES	true
#else
	#define	JOKER_STACK_TRACES			false
	#define	JOKER_MINI_DEBUGGER			false
	#define JOKER_CHUNK_TYPES			false
	#define	JOKER_DUMP_INSTRUCTIONS		false
	#define	JOKER_DEBUG_OUTPUT_LINES	false
#endif


/* The constants below are used by Joker to properly output information about
	this version to a console window. If JOKER_VERSION_NUMBER is "1.0" and
	JOKER_PLATFORM_FIX_NUMBER is 1 this means that it's the second release
	of Joker 1.0 on the Mac with some bug fixes to the Mac-specific parts only.
	You should reset the fix number to zero every time JOKER_VERSION_NUMBER
	changes. */
#define JOKER_PLATFORM_NAME			"Macintosh"
#define JOKER_PLATFORM_FIX_NUMBER	0
#define JOKER_PLATFORM_COPYRIGHT	"M. Uli Kusterer, (c) 1999-2001."