/*	***************************************************************************

	PROJECT:	ValueStack
	
	FILE:		ValueStack.h
	
	PURPOSE:	The stack on which parameters and variables are kept.
				This is the Mac-specific subclass that holds platform-specific
				stuff like the AppleEvent record during an appleEvent system
				message.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-07	UK		Created.
				
	************************************************************************ */

#ifndef	VALUESTACK_H
#define VALUESTACK_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"BasicValueStack.h"
#include	<AppleEvents.h>


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

/* Warning:	Most code should never need to access the methods of ValueStack that
			aren't inherited from BasicValueStack. Calling ValueStack-specific
			methods will make your code platform-dependent! */

class	ValueStack : public BasicValueStack
{
protected:
	AppleEventPtr		mCurrAppleEvent;
	AppleEventPtr		mCurrAEReply;
	bool				mAEWasHandled;

public:
			ValueStack() : BasicValueStack()	{ mCurrAppleEvent = mCurrAEReply = NULL; mAEWasHandled = true; };
	virtual	~ValueStack()						{};
	
	AppleEventPtr		GetCurrMacAEvt()	{ return mCurrAppleEvent; };
	void				SetCurrMacAEvt( const AEDesc* a )	{ mCurrAppleEvent = const_cast<AppleEventPtr>(a); };
	
	AppleEventPtr		GetCurrMacAEReply()	{ return mCurrAEReply; };
	void				SetCurrMacAEReply( AppleEventPtr a )	{ mCurrAEReply = a; };
	
	void				SetCurrMacAEHandled( bool h )			{ mAEWasHandled = h; };
	bool				GetCurrMacAEHandled()					{ return mAEWasHandled; };
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */










#endif /*VALUESTACK_H*/


