////////////////////////////////////////////////////////////////////////////////
// Copyright  1992 Apple Computer, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////

/* AEUserTerminology.h															*/
/* Conforms with Winter 1992 Apple Event Registry of December 19, 1992.			*/

#include "Types.r"		/* must come before AEUserTermTypes.r */
#include "AEUserTermTypes.r"
#include "AppleEvents.r"
#include "AEObjects.r"
#include "AERegistry.r"

resource 'aete' (0, "Moose Dictionary", sysheap) {
	0x01,
	0x00,
	english,
	roman,
	{	/* array Suites: 3 elements */
		/* [1] */
		"Required Suite",
		"Terms that every application should support",
		kAERequiredSuite,
		1,
		1,
		{	/* array Events: 2 elements */
			/* [1] */
			"quit",
			"Quit application",
			kCoreEventClass,
			kAEQuitApplication,
			noReply,
			"",
			replyOptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			noParams,
			"no direct parameter required",
			directParamOptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			{	/* array OtherParams: 0 elements */
			},
			/* [2] */
			"run",
			"Sent to an application when it is double-clicked",
			kCoreEventClass,
			kAEOpenApplication,
			noReply,
			"",
			replyOptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			noParams,
			"no direct parameter required",
			directParamOptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			{	/* array OtherParams: 0 elements */
			}
		},
		{	/* array Classes: 0 elements */
		},
		{	/* array ComparisonOps: 0 elements */
		},
		{	/* array Enumerations: 0 elements */
		},
		/* [2] */
		"Joker Suite",		/* Moose Suite */
		"Events specific to Joker.",
		'JOKR',
		1,
		1,
		{	/* array Events: 2 element */
			/* [1] */
			"show off",
			"Just so we can show off.",
			'JOKR',
			'dumy',
			noReply,
			"",
			replyOptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			noParams,
			"no direct parameter required",
			directParamOptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			{	/* array OtherParams: 0 elements */
			},
			/* [2] */
			"danceSome",
			"for testing only.",
			'JOKR',
			'danc',
			noReply,
			"",
			replyOptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			noParams,
			"no direct parameter required",
			directParamOptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			reserved, reserved, reserved, reserved,
			{	/* array OtherParams: 0 elements */
			}
		},
		{
			/* No Classes */
		},
		{
			/* No comparison ops */
		},
		{
			/* No enumerations */
		},
	}
};
