/*	***************************************************************************

	PROJECT:	MDrawingEnvironment
	
	FILE:		MDrawingEnvironment.cpp
	
	PURPOSE:	Macintosh-specific drawing routines.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-03-08	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"MacZoop.h"
#include	"MDrawingEnvironment.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -
#pragma mark [Init/Kill]

/* --------------------------------------------------------------------------------
	* CONSTRUCTOR:
		Do some initialization.
	
	REVISIONS:
		1999-03-8	UK		Created.
   ----------------------------------------------------------------------------- */

MDrawingEnvironment::MDrawingEnvironment()
	: DrawingEnvironment()
{
	// Do your stuff here!
}


/* --------------------------------------------------------------------------------
	* DESTRUCTOR:
		Do some cleanup.
	
	REVISIONS:
		1999-03-8	UK		Created.
   ----------------------------------------------------------------------------- */

MDrawingEnvironment::~MDrawingEnvironment()
{
	// Do your stuff here!
}


#pragma mark [Class Methods]

/* --------------------------------------------------------------------------------
	DrawLine:
		Draw a line from one to another point.
	
	REVISIONS:
		1999-03-08	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::DrawLine( DEPoint fromPt, DEPoint endPt )
{
	SetUpPort();
	
	MoveTo( fromPt.x, fromPt.y );
	LineTo( endPt.x, endPt.y );
	
	RestorePort();
}


/* --------------------------------------------------------------------------------
	DrawPoint:
		Color a pixel with the foreground color at the specified point.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::DrawPoint( DEPoint thePt )
{
	SetUpPort();
	
	RGBColor		vColor;
	Point			vMacPoint;
	
	vColor.red = mForeColor.red;
	vColor.green = mForeColor.green;
	vColor.blue = mForeColor.blue;
	
	SetCPixel( thePt.x, thePt.y, &vColor );
	
	RestorePort();
}


/* --------------------------------------------------------------------------------
	GetPointColor:
		Return the specified font's color.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

DEColor		MDrawingEnvironment::GetPointColor( DEPoint thePt )
{
	SetUpPort();
	
	RGBColor		vColor;
	DEColor			vResultColor;
	
	GetCPixel( thePt.x, thePt.y, &vColor );
	
	RestorePort();
	
	vResultColor.red = vColor.red;
	vResultColor.green = vColor.green;
	vResultColor.blue = vColor.blue;
	
	return vResultColor;
}


/* --------------------------------------------------------------------------------
	FrameRect:
		Draw the specified rect framed.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::FrameRect( DERect theBox )
{
	SetUpPort();
	
	Rect		vMacBox;
	
	DERectToMac( theBox, &vMacBox );
	FrameRect( &vMacBox );
	
	RestorePort();
}


/* --------------------------------------------------------------------------------
	FillRect:
		Draw the specified rect filled. This is supposed to overdraw the framed
		version entirely, which requires a bit of nudging on the Mac.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::FillRect( DERect theBox )
{
	SetUpPort();
	
	Rect		vMacBox;

	DERectToMac( theBox, &vMacBox );
	vMacBox.right++; vMacBox.bottom++;	// Nudge bot & right by 1 pixel since Mac is different to our spec here.
	PaintRect( &vMacBox );
	
	RestorePort();
}


/* --------------------------------------------------------------------------------
	FrameEllipsis:
		Draw the specified oval framed.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::FrameEllipsis( DERect theBox )
{
	SetUpPort();
	
	Rect		vMacBox;
	
	DERectToMac( theBox, &vMacBox );
	FrameOval( &vMacBox );
	
	RestorePort();
}


/* --------------------------------------------------------------------------------
	FillEllipsis:
		Draw the specified oval filled. This is supposed to overdraw the framed
		version entirely, which requires a bit of nudging on the Mac.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::FillEllipsis( DERect theBox )
{
	SetUpPort();
	
	Rect		vMacBox;

	DERectToMac( theBox, &vMacBox );
	vMacBox.right++; vMacBox.bottom++;	// Nudge bot & right by 1 pixel since Mac is different to our spec here.
	PaintOval( &vMacBox );
	
	RestorePort();
}


#pragma mark -
#pragma mark [Platform-specific calls]

/* --------------------------------------------------------------------------------
	SetUpPort:
		Ensure we draw to the right place.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::SetUpPort()
{
	GetGWorld( &mOldPort, &mOldDevice );
	SetGWorld( (CGrafPtr) mMacGrafPort, NULL );
}


/* --------------------------------------------------------------------------------
	RestorePort:
		Ensure we draw to the right place.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::RestorePort()
{
	SetGWorld( mOldPort, mOldDevice );
}


/* --------------------------------------------------------------------------------
	DERectToMac:
		Convert a DERect to a Macintosh Quickdraw Rect.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::DERectToMac( DERect inBox, Rect *outBox )
{
	outBox->top = inBox.top;
	outBox->left = inBox.left;
	outBox->bottom = inBox.bottom;
	outBox->right = inBox.right;
}


/* --------------------------------------------------------------------------------
	MacRectToDE:
		Convert a Macintosh Quickdraw Rect to a DERect.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::MacRectToDE( Rect inBox, DERect *outBox )
{
	outBox->top = inBox.top;
	outBox->left = inBox.left;
	outBox->bottom = inBox.bottom;
	outBox->right = inBox.right;
}


/* --------------------------------------------------------------------------------
	DEPointToMac:
		Convert a DEPoint to a Macintosh Quickdraw Point.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::DEPointToMac( DEPoint inPoint, Point *outPoint )
{
	outPoint->h = inPoint.x;
	outPoint->v = inPoint.y;
}


/* --------------------------------------------------------------------------------
	MacPointToDE:
		Convert a Macintosh Quickdraw Point to a DEPoint.
	
	REVISIONS:
		1999-11-06	UK		Created.
   ----------------------------------------------------------------------------- */

void	MDrawingEnvironment::MacPointToDE( Point inPoint, DEPoint *outPoint )
{
	outPoint->x = inPoint.h;
	outPoint->y = inPoint.v;
}







