/*	

	PROJECT:	MDrawingEnvironment
	
	FILE:		MDrawingEnvironment.h
	
	PURPOSE:	Macintosh-specific drawing routines.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-11-06	UK		Implemented drawing of point, rect, ellipsis.
		1999-03-08	UK		Created.
				
	 */

#pragma mark [Headers]

/* 
	Headers:
    */
   
#include	"DrawingEnvironment.h"


#pragma mark [Class Declaration]

/* 
	Class declaration:
    */

class	MDrawingEnvironment : public DrawingEnvironment
{
protected:
	GrafPtr				mMacGrafPort;	// The graphics port we're drawing into.
	CGrafPtr			mOldPort;		// Used by RestorePort() to restore port.
	GDHandle			mOldDevice;		// Used by RestorePort() to restore device.

public:
	MDrawingEnvironment();
	~MDrawingEnvironment();
	
// Points:
	virtual void		DrawPoint( DEPoint thePt );
	virtual DEColor		GetPointColor( DEPoint thePt );

// Lines:
	virtual void		DrawLine( DEPoint fromPt, DEPoint endPt );
	
// Shapes:
	virtual void		FrameRect( DERect theRect );
	virtual void		FillRect( DERect theRect );
	
	virtual void		FrameEllipsis( DERect theRect );
	virtual void		FillEllipsis( DERect theRect );
	
	virtual void		FrameRoundrect( DERect theRect )					= 0;
	virtual void		FillRoundrect( DERect theRect )						= 0;

	virtual void		FramePolygon( DEPolygon thePoly, bool autoClose )	= 0;
	virtual void		FillPolygon( DEPolygon thePoly )					= 0;

// Save/Read (to/from PNG files):
	virtual void		DrawFile( FILE* theFile, DERect* theRect = NULL, bool scaleDontCrop = true )	= 0;
	virtual void		ExportToFile( FILE* theFile, DERect* theRect = NULL )	= 0;

protected:
	virtual void		SetUpPort();
	virtual void		RestorePort();
};


#pragma mark [Prototypes]

/* 
	Prototypes:
    */













