/*	

	PROJECT:	MacQuickDraw
	
	FILE:		MacQuickDraw.h
	
	PURPOSE:	Macintosh-specific drawing routines.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-03-8	UK		Created.
				
	 */

#pragma mark [Headers]

/* 
	Headers:
    */
   
#include	"DrawingEnvironment.h"


#pragma mark [Class Declaration]

/* 
	Class declaration:
    */

class	MacQuickDraw : public DrawingEnvironment
{
protected:
	// Put your member variables here.

public:
	MacQuickDraw();
	~MacQuickDraw();
	
	DrawingEnvironment()		{};
	virtual				~DrawingEnvironment();
	
// Global manipulation:
	virtual void		SetSize( long width, long height )					= 0;
	virtual DERect		GetSize()											= 0;
	virtual void		SetDepth( long theDepth )							= 0;
	virtual long		GetDepth()											= 0;
	
// Pen positioning:
	virtual void		MovePenTo( DEPoint pos )							{ mPenPosition = pos; };
	virtual DEPoint		GetPenPosition()									{ return mPenPosition; };

// Points:
	virtual void		DrawPoint( DEPoint thePt )							= 0;
	virtual DEColor		GetPointColor( DEPoint thePt )						= 0;

// Lines:
	virtual void		DrawLineTo( DEPoint endPt )							= 0;
	virtual void		SetLineSize( long width, long height )				{ mLineSize.x = width; mLineSize.y = height; };
	virtual DEPoint		GetLineSize() 										{ return mLineSize; };
	
// Colors:
	virtual	void		SetForeColor( DEColor theColor )					{ mForeColor = theColor; };
	virtual	DEColor		GetForeColor()										{ return mForeColor; };
	virtual	void		SetBackColor( DEColor theColor )					{ mBackColor = theColor; };
	virtual	DEColor		GetBackColor()										{ return mBackColor; };

// Shapes:
	virtual void		FrameRect( DERect theRect )							= 0;
	virtual void		FillRect( DERect theRect )							= 0;
	virtual void		FrameAndFillRect( DERect theRect )					{ FillRect( theRect ); FrameRect( theRect ); };
	
	virtual void		FrameEllipse( DERect theRect )						= 0;
	virtual void		FillEllipse( DERect theRect )						= 0;
	virtual void		FrameAndFillEllipse( DERect theRect )				{ FillEllipse( theRect ); FrameEllipse( theRect ); };
	
	virtual void		FrameRoundrect( DERect theRect )					= 0;
	virtual void		FillRoundrect( DERect theRect )						= 0;
	virtual void		FrameAndFillRoundrect( DERect theRect )				{ FillRoundrect( theRect ); FrameRoundrect( theRect ); };

	virtual void		FramePolygon( DEPolygon thePoly, bool autoClose )	= 0;
	virtual void		FillPolygon( DEPolygon thePoly )					= 0;
	virtual void		FrameAndFillPolygon( DEPolygon thePoly, bool autoClose )		{ FillPolygon( thePoly ); FramePolygon( thePoly, autoClose ); };

// Save/Read (to/from PNG files):
	virtual void		DrawFile( FILE* theFile, DERect* theRect = NULL, bool scaleDontCrop = true )	= 0;
	virtual void		ExportToFile( FILE* theFile, DERect* theRect = NULL )	= 0;
};


#pragma mark [Prototypes]

/* 
	Prototypes:
    */













