/*
	Part of Joker, (c) 1999-2000 by M. Uli Kusterer, all rights rsvd.
	
	TalkCallRecord contains information used by every handler call internally
	while it is running and is passed to every instruction.
*/


#pragma once

#include	"TalkMemLocation.h"

class	TalkCallRecord
{
public:
	bool				mExitHandler;		// Set to TRUE by instructions that exit the current handler.
	bool				mPassFlag;			// Set to TRUE by instructions that pass the current message and don't swallow it when exiting.
	bool				mExitCompletely;	// Set to TRUE by instructions that exit not just the current message but also all handlers in the calling chain.
	bool				mException;			// Set to TRUE when an exception occurs.
	
	size_t				mChunkStartOffs;	// This and the one below are used to incrementally reduce the amount of data that needs to be copied during nested chunks.
	size_t				mChunkEndOffs;
	
	TalkEntity*			mTarget;			// The current value of the target. Usually the same as GetAssociatedObject(), except for calls that are passed.
	
public:
	TalkCallRecord()	{ mExitHandler = false; mPassFlag = false; mExitCompletely = false; mChunkStartOffs = mChunkEndOffs = 0; mException = false; mTarget = NULL; };
};