/* ================================================================================

	PROJECT:	Joker.mcp
	
	FILE:		TalkEntity.h
	
	PURPOSE:	An object that can be manipulated using JokerTalk.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-14	UK		Created.
				
   ============================================================================= */

#ifndef TALKENTITY_H
#define TALKENTITY_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	<stdio.h>


#pragma mark [Forwards]

/* --------------------------------------------------------------------------------
	Forwards:
   ----------------------------------------------------------------------------- */

class TextMunger;
class TalkValue;
class HyperTalk;

#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	TalkEntity
{
protected:
	// Put your member variables here.

public:
			TalkEntity();
	virtual	~TalkEntity();
	
	virtual void		GetPropertyValue( const TextMunger& pName, TalkValue& outValue ) const = 0;
	virtual void		SetPropertyValue( const TextMunger& pName, const TalkValue& inValue ) = 0;
	virtual TalkValue*	GetContents() const = 0;
	virtual void		Delete() = 0;
	
	virtual HyperTalk*	GetScript()	{ return NULL; };	// Return NULL here if your object can not receive messages. Otherwise, return your script object.
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */

/* Host-specific function that returns the object that is to be used when the
	"set" command receives a property without specifying an object. Defaults to
	just calling GetApplicationObject(). */

TalkEntity*		GetPropertyDefaultObject();

/* Host-specific function that returns the application entity, i.e. the last
	instance above any documents. */
TalkEntity*		GetApplicationObject();










#endif /*TALKENTITY_H*/