/* ================================================================================

	PROJECT:	MaxJoker.mcp
	
	FILE:		TalkExtendableEntity.h
	
	PURPOSE:	Entity that knows how to handle user properties.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-21	UK		Created.
				
   ============================================================================= */

#ifndef TALKEXTENDABLEENTITY_H
#define TALKEXTENDABLEENTITY_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	"TalkEntity.h"
#include	"TalkValue.h"


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	TalkExtendableEntity : public TalkEntity
{
protected:
	TalkValueList		mUserProperties;

public:
			TalkExtendableEntity();
	virtual	~TalkExtendableEntity();
	
	virtual void		GetPropertyValue( const TextMunger& pName, TalkValue& outValue ) const;
	virtual void		SetPropertyValue( const TextMunger& pName, const TalkValue& inValue );
	
	virtual TalkValue*	CopyPropertyArray();
	virtual void		SetPropertyArray( const TalkValue& inValue );
	virtual TalkValue*	CopyPropertyNameArray();
	virtual void		MergePropertyArrays( TalkExtendableEntity* ent, bool skipDuplicates );
	
	virtual void		DefineProperty( const TextMunger& pName );
	virtual void		UndefineProperty( const TextMunger& pName );
	void				KillUserProperties();
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */













#endif /*TALKEXTENDABLEENTITY_H*/