/* =============================================================================
	PROJECT:	Joker
	FILE:		TalkScriptBlock.h
	
    PURPOSE:	Each part of a script "block", e.g. function handler
                definition, message handler definition, script-global (as
                opposed to application-global) variable etc., must have a
                TalkScriptBlock subclass registered with the parser that
                takes care of parsing this particular block. Each such block
                has a certain identifier at the start of a line that it is
                keyed to and will scan until it hits some sort of "end"
                indicator or it runs out of data.
                
                E.g. if you want to support definition of some sort of
                object class in a script, subclass TalkScriptBlock and
                register your subclass for the identifier "class" or whatever.
                
    COPYRIGHT:	Copyright (c) 2001 M. Uli Kusterer. All rights reserved.
    
    REVISIONS:
        Thu Sep 27 2001	witness	Created.
   ========================================================================== */

#pragma once

/* -----------------------------------------------------------------------------
    Data Types:
   -------------------------------------------------------------------------- */

#include	"HyperToken.h"

// We don't #include "HyperTalk.h" to avoid circular dependencies.
class	HyperTalk;


/* -----------------------------------------------------------------------------
    Classes:
   -------------------------------------------------------------------------- */

class	TalkScriptBlock
{
public:
    TalkScriptBlock() {};
    virtual ~TalkScriptBlock() {};
    virtual void	Parse( HyperTalk& vScript, HyperTokenList& vTokens,
							HTLIterator& iterator, long &vCurrLineNum );
};

/* TalkFcnHandlerBlock:
    This is the kind of block that is used for parsing function handlers in a script.
    It simply delegates the parsing back to the script's ParseHandler() method for
	historical reasons. */
class	TalkFcnHandlerBlock : public TalkScriptBlock
{
public:
    TalkFcnHandlerBlock() : TalkScriptBlock() {};
    virtual ~TalkFcnHandlerBlock() {};
    
    virtual void	Parse( HyperTalk& vScript, HyperTokenList& vTokens,
							HTLIterator& iterator, long &vCurrLineNum );
};

/* TalkCmdHandlerBlock:
    This is the kind of block that is used for parsing command handlers in a script.
    It simply delegates the parsing back to the script's ParseHandler() method for
	historical reasons. */
class	TalkCmdHandlerBlock : public TalkScriptBlock
{
public:
    TalkCmdHandlerBlock() : TalkScriptBlock() {};
    virtual ~TalkCmdHandlerBlock() {};
    
    virtual void	Parse( HyperTalk& vScript, HyperTokenList& vTokens,
							HTLIterator& iterator, long &vCurrLineNum );
};