/*	***************************************************************************

	PROJECT:	Joker
	
	FILE:		TalkTokenize.h
	
	PURPOSE:	Tokenizer part of the HyperTalk interpreter.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-10-23	UK		Created.
				
	************************************************************************ */

#pragma once
#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"HyperToken.h"


#pragma mark [Data Types]

/* --------------------------------------------------------------------------------
	Data Types:
   ----------------------------------------------------------------------------- */

typedef std::map<TextMunger,TokenTypeEnum>		TalkIdentifierList;


#pragma mark [Class declaration]

/* --------------------------------------------------------------------------------
	Class Declaration:
   ----------------------------------------------------------------------------- */

class	TalkTokenizer
{
protected:
	static TalkIdentifierList		mIdentifiers;
	static char						mNewlineChar;
	static long						mTokenIDSeed;

public:
	static void					Init();
	static TokenTypeEnum		GetIdentifierType( TextMunger& vIdentifierName );
	static TokenTypeEnum		GetOrCreateToken( const char* str );
	static void					RegisterIdentifierToken( const TextMunger& vIdentifierName,
														TokenTypeEnum vTokenType );
	static TokenTypeEnum		GetNewTokenID()		{ return mTokenIDSeed++; };
	static OperatorTypeEnum		GetOperatorTokenKind( HyperToken* theToken );
	static void					ReplaceEscapeSequences( char* vString );
	static char					GetNewline()		{ return mNewlineChar; };
	static void					SetNewline( char n )	{ mNewlineChar = n; };
	
};