/*	***************************************************************************

	PROJECT:	TalkURLValue
	
	FILE:		TalkURLValue.h
	
	PURPOSE:	A value of a variable.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-11-28	UK		Created.
				
	************************************************************************ */

#ifndef TALKURLVALUE_H
#define TALKURLVALUE_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	"TalkValue.h"
#include	<stdexcept>


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	TalkURLValue : public TalkValue
{
protected:
	TextMunger		mTheURL;

public:
		// These copy the value passed in:
				TalkURLValue() : TalkValue()									{};
	explicit	TalkURLValue( const TextMunger& n ) : TalkValue(), mTheURL(n)	{};
			
	virtual ~TalkURLValue();
			
	virtual unsigned long	GetAvailableTypes() const;
	virtual unsigned long	GetNativeType() const			{ return VALUE_TYPE_TEXT; };
	
	virtual void	GetValue( ValueStorage &returnValue, unsigned long desiredType, std::size_t startOffs = 0, std::size_t endOffs = 0 ) const;
	virtual void	SetValue( ValueStorage inValue, unsigned long providedType, bool followRefs = false, std::size_t startOffs = 0, std::size_t endOffs = 0 );
	virtual void	CopyValueTo( TalkValue& vDestValue, bool followSrcRefs = false, bool followDstRefs = false ) const;
	
	virtual void	GetListEntry( TalkValue* &returnValue, const TextMunger& index );
	virtual void	SetList( const TalkValueList& vList );
	virtual void	CopyListTo( TalkValueList& vList ) const;
	virtual void	KillList()			{};
	
	virtual void	SetChunkRange( std::size_t offsStart, std::size_t offsEnd );
	virtual bool	GetChunkRange( std::size_t& offsStart, std::size_t& offsEnd ) const	{ return false; };
	virtual void	ClearChunkRange()	{};
	
	virtual	TextMunger*		GetKeys() const			{ return NULL; };
	virtual long			CountEntries() const	{ return 0; };
	
	virtual void		GetPropertyValue( const TextMunger& pName, TalkValue& outValue ) const;
	virtual void		SetPropertyValue( const TextMunger& pName, const TalkValue& inValue )	{ throw std::runtime_error("Can't set this property."); };
	virtual TalkValue*	GetContents() const		{ throw std::runtime_error("Screwed! Can't address URL as entity!"); };
	
	virtual void		Delete( std::size_t startOffs, std::size_t endOffs = 0 );
	
protected:
	void			GetChunk( ValueStorage &returnValue, unsigned long desiredType,
								std::size_t startOffs, std::size_t endOffs ) const;
	TextMunger*		DownloadURLData() const;
	void			UploadURLData( TextMunger* vData ) const;
	void			KillURLFile();
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */









#endif /*TALKURLVALUE_H*/



