/*	***************************************************************************

	PROJECT:	TalkVarValue
	
	FILE:		TalkVarValue.h
	
	PURPOSE:	A value of a variable.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-11-28	UK		Created.
				
	************************************************************************ */

#ifndef TALKVARVALUE_H
#define TALKVARVALUE_H

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	"TalkValue.h"


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	BasicValueStack;	// Fwd for debug aid.

class	TalkVarValue : public TalkValue
{
friend	class BasicValueStack;	// Debug aid.

protected:
	unsigned long		mNativeType;
	ValueStorage		mValue;
	TalkValueList		mList;
	std::size_t			mSubStartOffs;
	std::size_t			mSubEndOffs;
	bool				mSubIsValid;

public:
		// These copy the value passed in:
			TalkVarValue( const long n ) : TalkValue()				{ mNativeType = VALUE_TYPE_LONG; mValue.longType = n; mSubIsValid = false; };
			TalkVarValue( const double n ) : TalkValue()			{ mNativeType = VALUE_TYPE_DOUBLE; mValue.doubleType = n; mSubIsValid = false; };
			TalkVarValue( const bool n ) : TalkValue()				{ mNativeType = VALUE_TYPE_BOOL; mValue.boolType = n; mSubIsValid = false; };
			TalkVarValue( const TextMunger& inMun ) : TalkValue()	{ mNativeType = VALUE_TYPE_TEXT; mValue.textType = new TextMunger( inMun ); mSubIsValid = false; };
			TalkVarValue( const LongPoint& n ) : TalkValue()		{ mNativeType = VALUE_TYPE_POINT; mValue.pointType = n; mSubIsValid = false; };
			TalkVarValue( const LongColor& n ) : TalkValue()		{ mNativeType = VALUE_TYPE_COLOR; mValue.colorType = n; mSubIsValid = false; };
			TalkVarValue( const LongRect& n ) : TalkValue()			{ mNativeType = VALUE_TYPE_RECT; mValue.rectType = n; mSubIsValid = false; };
	
		// Takes over the textMunger passed in (used by string parse code):
	explicit TalkVarValue( TextMunger* inMun ) : TalkValue()		{ mNativeType = VALUE_TYPE_TEXT; mValue.textType = inMun; mSubIsValid = false; };
	explicit TalkVarValue( TalkEntity* inEnt ) : TalkValue()		{ mNativeType = VALUE_TYPE_ENTITY; mValue.entityType = inEnt; mSubIsValid = false; };
	
	virtual ~TalkVarValue();
	
	void		GetPropertyValue( const TextMunger& pName, TalkValue& outValue ) const;
	void		SetPropertyValue( const TextMunger& pName, const TalkValue& inValue );
	TalkValue*	GetContents() const;
			
	virtual unsigned long	GetAvailableTypes() const;
	virtual unsigned long	GetNativeType() const			{ return mNativeType; };
	
	virtual void	GetValue( ValueStorage &returnValue, unsigned long desiredType, std::size_t startOffs = 0, std::size_t endOffs = 0 ) const;
	virtual void	SetValue( ValueStorage inValue, unsigned long providedType, bool followRefs = false, std::size_t startOffs = 0, std::size_t endOffs = 0 );
	virtual void	CopyValueTo( TalkValue& vDestValue, bool followSrcRefs = false, bool followDstRefs = false ) const;
	
	virtual void	GetListEntry( TalkValue* &returnValue, const TextMunger& index );
	virtual void	SetList( const TalkValueList& vList );
	virtual void	CopyListTo( TalkValueList& vList ) const;
	virtual void	KillList();
	
	virtual void	SetChunkRange( std::size_t offsStart, std::size_t offsEnd );
	virtual bool	GetChunkRange( std::size_t& offsStart, std::size_t& offsEnd ) const	{ if( mSubIsValid ) { offsStart = mSubStartOffs; offsEnd = mSubEndOffs; } return mSubIsValid; };
	virtual void	ClearChunkRange()	{ mSubIsValid = false; };
	
	virtual void	Delete( std::size_t startOffs, std::size_t endOffs = 0 );
	
	virtual	TextMunger*		GetKeys() const;
	virtual long			CountEntries()  const	{ return mList.size(); };
	
protected:
	void			GetChunk( ValueStorage &returnValue, unsigned long desiredType,
								std::size_t startOffs, std::size_t endOffs ) const;
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */









#endif /*TALKVARVALUE_H*/



