/*	***************************************************************************

	PROJECT:	XSmartPointer
	
	FILE:		XSmartPointer.h
	
	PURPOSE:	Handle pointers in a smart way. This throws an exception
				whenever someone tries to access a NULL pointer.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-05-06	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]
#pragma once

#ifndef X_SMART_POINTER_H
#define X_SMART_POINTER_H

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	XSmartPointer
{
protected:
	char*			mPointer;		// The actual pointer.

public:
	XSmartPointer()	: mPointer(0L) {};
	XSmartPointer( char* vPtr )	: mPointer(vPtr) {};

	operator char* ();
	operator long ();
	char operator* ();
	char operator-> ();
	bool operator==(const XSmartPointer& rhs);
	bool operator==(const int rhs);
	bool operator==(const long& rhs);
	bool operator==(const char* rhs);
	bool operator!=(const XSmartPointer& rhs);
	bool operator!=(const int rhs);
	bool operator!=(const long& rhs);
	bool operator!=(const char* rhs);
	XSmartPointer& operator=(const XSmartPointer& val);
	XSmartPointer& operator=(char* val);
};


#endif /*X_SMART_POINTER_H*/










