/* ================================================================================

	PROJECT:	missinghandler_error
	
	FILE:		missinghandler_error.h
	
	PURPOSE:	Exception thrown when a handler can't be found.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-07	UK		Created.
				
   ============================================================================= */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	<stdexcept>
#include	"TextMunger.h"


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	missinghandler_error : public std::runtime_error
{
protected:
	TextMunger		mHandlerName;

public:
			missinghandler_error( const std::string& what_arg, const TextMunger& handName );
	virtual	~missinghandler_error() throw();
	
	TextMunger&		GetHandlerName()	{ return mHandlerName; };
};

missinghandler_error::~missinghandler_error() throw()
{
	;	
}

#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */













