/* ================================================================================

	PROJECT:	missingproperty_error
	
	FILE:		missingproperty_error.h
	
	PURPOSE:	Exception thrown when a property can't be found.
		
	COPYRIGHT:	(C) Copyright 2000 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2000-11-07	UK		Created.
				
   ============================================================================= */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include	<stdexcept>
#include	"TextMunger.h"


#pragma mark [Class Declaration]

/* --------------------------------------------------------------------------------
	Class declaration:
   ----------------------------------------------------------------------------- */

class	missingproperty_error : public std::runtime_error
{
protected:
	TextMunger		mPropertyName;

public:
			missingproperty_error( const std::string& what_arg, const TextMunger& propName )
				: runtime_error( what_arg ), mPropertyName( propName ) {};
	virtual	~missingproperty_error()	{};
	
	TextMunger&		GetPropertyName()	{ return mPropertyName; };
};


#pragma mark [Prototypes]

/* --------------------------------------------------------------------------------
	Prototypes:
   ----------------------------------------------------------------------------- */













