/* Set this to true to output lots of additional
	debugging info during runtime. */
#define		JOKER_DEBUG					0

// Displays info about this version of Joker on startup:
#define 	JOKER_DISPLAY_VERSION		1

#if JOKER_DEBUG
	// Dumps the stack to the console before and after every function call:
	#define	JOKER_STACK_TRACES			0
	// Dumps the stack after each line of the script executed:
	#define JOKER_STACK_TRACES_LINEWISE	0
	// Displays a mini-debugger that lets you step through the code, dump stack states etc.
	#define	JOKER_MINI_DEBUGGER			0
	// Output a pseudo-disassembly of every instruction AFTER executing it:
	#define JOKER_PRINT_INSTR_LINEWISE	0
	// Outputs chunk types and ranges during chunk operations:
	#define JOKER_CHUNK_TYPES			0
	// Dumps the compiled instructions:
	#define JOKER_DUMP_INSTRUCTIONS		0
	// Dumps a notification whenever one line has been executed:
	#define	JOKER_DEBUG_OUTPUT_LINES	0
	// Prints out the first token of every command before parsing it:
	#define JOKER_DUMP_FIRST_CMD_TOKENS	0
	// Dump the identifiers encountered during parsing of a built-in command:
	#define JOKER_DUMP_CMD_IDENTS		0
	// Dumps each instruction as it is added to the script:
	#define	JOKER_DUMP_INSTR_PUSHES		1
#else
	#define	JOKER_STACK_TRACES			0
	#define JOKER_STACK_TRACES_LINEWISE	0
	#define	JOKER_MINI_DEBUGGER			0
	#define JOKER_PRINT_INSTR_LINEWISE	0
	#define JOKER_CHUNK_TYPES			0
	#define JOKER_DUMP_INSTRUCTIONS		0
	#define	JOKER_DEBUG_OUTPUT_LINES	0
	#define JOKER_DUMP_FIRST_CMD_TOKENS	0
	#define JOKER_DUMP_CMD_IDENTS		0
	#define	JOKER_DUMP_INSTR_PUSHES		0
#endif


/* The constants below are used by Joker to properly output information about
	this version to a console window. If JOKER_VERSION_NUMBER is "1.0" and
	JOKER_PLATFORM_FIX_NUMBER is 1 this means that it's the second release
	of Joker 1.0 on the Mac with some bug fixes to the Mac-specific parts only.
	You should reset the fix number to zero every time JOKER_VERSION_NUMBER
	changes. JOKER_PLATFORM_COPYRIGHT is a copyright sentence that can be used
	to continue a sentence like "Generic port by ..." */
#define JOKER_PLATFORM_NAME			"Generic"
#define JOKER_PLATFORM_FIX_NUMBER	0
#define JOKER_PLATFORM_COPYRIGHT	"M. Uli Kusterer, (c) 1999-2000."