/*	***************************************************************************

	PROJECT:	Joker
	
	FILE:		CarbTalkInstructions.h
	
	PURPOSE:	Instructions in a script.
		
	COPYRIGHT:	(C) Copyright 2001 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-02-14	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"TalkInstructions.h"
#include	"HyperTalk.h"
#include	"TalkVarValue.h"
#include	"JokerMain.h"
#include	<iostream>
#if __MACH__
#include	<Carbon/Carbon.h>
#else
#include	<Carbon.h>
#endif

void	JokerSpendTime()
{
	// Called after every command, e.g. to let you poll for events.
	// FIX ME! Insert your idle processing code here.
}

#pragma mark -
#pragma mark [Instruction Procs]

/* --------------------------------------------------------------------------------
	All instruction procedures take two parameters, an "HI" parameter that contains
	the instruction's parameters and destination for the result along with other
	info like a pointer to the object currently running, and an "s" parameter
	that points to the stack with the variables for this instruction.
   ----------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------------
	HyperReplyInstruction:
		This implements the "reply" command that can be used to return information
		from an appleEvent message. This is inherently Mac-specific, but maybe
		some hosts want to support this as a compatibility layer.
	
	HI's FIELDS:
		0		-	TRUE if this is "reply error", FALSE if just "reply".
		1		-	Expression to return.
		2		-	TRUE if "with" follows expression, FALSE if omitted.
		3		-	The AppleEvent keyword or an empty string if none specified.
		Result	-	*unused*
   ----------------------------------------------------------------------------- */

void	HyperReplyInstruction( struct HyperInstruction& hi, ValueStack& s,
									TalkCallRecord& vCallRec )
{
    throw std::runtime_error("The \"reply\" command isn't supported on this platform.");
}


/* --------------------------------------------------------------------------------
	HyperRequestInstruction:
		This implements the "request" command that can be used to obtain
		information from an appleEvent message. This is inherently Mac-specific,
		but maybe some ports want to support this partially as a compatibility
		layer for CGIs etc.
	
	HI's FIELDS:
		0		-	What to request, i.e. "data", "sender", "id", "class" etc.
		1		-	TRUE if "with" follows expression, FALSE if omitted.
		2		-	The AppleEvent keyword or an empty string if none specified.
		Result	-	The data requested.
   ----------------------------------------------------------------------------- */

void	HyperRequestInstruction( struct HyperInstruction& hi, ValueStack& s,
									TalkCallRecord& vCallRec )
{
    throw std::runtime_error("The \"reply\" command isn't supported on this platform.");
}


/* --------------------------------------------------------------------------------
	HyperAppleEventInstruction:
		This command traps the "appleEvent" message that is sent on Apple Events.
	
	HI's FIELDS:
		0		-	Event class
		1		-	Event ID
		2		-	Sender
		Result	-	*unused*
   ----------------------------------------------------------------------------- */

void	HyperAppleEventInstruction( struct HyperInstruction& hi, ValueStack& s,
									TalkCallRecord& vCallRec )
{
	/* FIX ME! You can notify the application here that nobody handled the apple event
		request. Or you can simply leave this here as a dummy that prevents the
		error message. */
}


/* --------------------------------------------------------------------------------
	HyperBeepInstruction:
		Output an error sound.
	
	HI's FIELDS:
		0		-	Number of times to beep.
		Result	-	*unused*
   ----------------------------------------------------------------------------- */

void	HyperBeepInstruction( struct HyperInstruction& hi, ValueStack& s,
							TalkCallRecord& vCallRec )
{
	ValueStorage	vCount;
	
	hi.mParam[0].GetValue( vCount, s, VALUE_TYPE_LONG );
	
	while( vCount.longType > 0 )
	{
		SysBeep(10);	// I'd use the bell character, but that gives a Bus Error in tcsh.
		vCount.longType--;
	}
}