/* =============================================================================
	FILE:		SerialNumber.cpp

	PURPOSE:	Code that takes a user name and generates a serial number
				string from that.

	AUTHOR:		M. Uli Kusterer, <witness@weblayout.com>

	CREDITS:	This code is based on a SuperTalk script by Geoff Canyon
				<gcanyon@inspiredlogic.com>.
	
	REVISIONS:
		2000-11-25	UK	Created.
   ========================================================================== */

/* -----------------------------------------------------------------------------
	Headers:
   -------------------------------------------------------------------------- */

#include	"SerialNumber.h"
#include	<cstdio>
#include	<cstdlib>
#include	<cstring>
#include	<cctype>

/* -----------------------------------------------------------------------------
	CalcSerialNumber:
		Generates a 9-character string consisting of the numeral characters
		from a text string passed in. This doesn't distinguish case.
	
	TAKES:
		userName	-	The C-string from which the number will be generated.
	
	GIVES:
		theSerial	-	The serial number as a nine-character C-string.
	
	REVISIONS:
		2000-11-25	UK	Created.
   -------------------------------------------------------------------------- */

void	CalcSerialNumber( const char* userName, char* theSerial )
{
	/* These three prime numbers should be in the thousands.
		Choosing different primes allows for different serial
		number systems, all based on the same code. */
	long		thePrimes[3] = { 1801, 1811, 1823 };
	
	/* This number also affects the final result. It doesn't
		have to be prime. It should be anywhere from about 20
		to 100. Again, changing it changes the result
		significantly. */
	long		theOffset = 50,
				thePrime,
				theTotal;
	short		howMany = strlen(userName);
	char		theSource[512];	// User name goes here.
	theSerial[0] = 0;	// Start with a blank.
	
	// Avoid case issues by converting user name to lower case:
	strcpy( theSource, userName );
	for( short x = 0; theSource[x] != 0; x++ )
		theSource[x] = tolower(theSource[x]);
	
	// Disallow names shorter than 3 characters:
	if( howMany < 3 )
		return;
	
	// For each of the primes:
	for( short i = 0; i < 3; i++ )
	{
		thePrime = thePrimes[i];
		theTotal = 0;
		
		// For each of the characters in the name:
		for( short j=0; j < howMany; j++ )
		{
			unsigned char		k;
			long				l;
			
			k = theSource[j];
			
			/* Get the position in the string plus the offset.
				This makes it sensitive to transpositions and
				increment/decrement issues. */
			
			l = j +theOffset;
			
			/* You could do other math here if you want, but
				this product gave good results for me: */
			theTotal += k * k * l * l;
			
			// Here we keep it in a reasonable range:
			theTotal %= thePrime;
		}
		
		// Now get it down to 3 characters:
		theTotal %= 1000;
		
		// Now fill it up with leading zeroes if needed and append it to our serial number:
		char		vStr[10];
		sprintf( vStr, "%ld", theTotal );
		
		while( strlen(vStr) < 3 )
		{
			short sl = strlen(vStr);
			
			// Move everything one character to the right:
			while( sl-- >= 0 )	// Postfix so we include the NULL byte.
				vStr[sl+1] = vStr[sl];
			
			vStr[0] = '0';	// Prefix a zero.
		}
		
		strcat( theSerial, vStr );	// Put it after our serial number.
	}
	
	/* Finally, reverse the whole 9-digit number to make leading zeroes trailing:
	for( short i = 9; i > 0; i++ )
	{
		char	tmpCh = theSerial[i-1];
		
		if( 9-i > 0 )
			memmove( &(theSerial[i-1]), &(theSerial[i]), 9 -i );
		theSerial[8] = tmpCh;
	}*/
}