/*	***************************************************************************

	PROJECT:	TalkTempVarList
	
	FILE:		TalkTempVarList.cpp
	
	PURPOSE:	Array of indices of our temp variables +pointer to first unused.
		
	COPYRIGHT:	(C) Copyright 1999 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		1999-12-01	UK		Created.
				
	************************************************************************ */

#pragma mark [Headers]

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include	"TalkTempVarList.h"


#pragma mark [Globals]

/* --------------------------------------------------------------------------------
	Globals/Static Variables:
   ----------------------------------------------------------------------------- */

// Put these li'l critters here.


#pragma mark -

/* --------------------------------------------------------------------------------
	GetNewTemp:
		Get the next unused temp's stack location, or if we have none create a
		new one, add it to our list of temps and return its stack location.
	
	TAKES:
		-
	
	GIVES:
		ValStackLocation	-	The index of the temp on the stack.
	
	REVISIONS:
		1999-12-01	UK		Created.
   ----------------------------------------------------------------------------- */

ValStackLocation	TalkTempVarList::GetNewTemp()
{
	ValStackLocation		vResult = 0;
	
	if( mFirstUnused >= size() )	// Are we out of temps? (Index is zero-based).
	{
		// Register a new variable (our temp) from stack:
		mStackVarCount++;	// mStackVarCount is a reference!!!
		mFirstUnused++;		// Make sure we don't use this temp a second time!
		
		vResult = mStackVarCount -1;	// Index is zero-based.
		push_back( vResult );	// Add new temp's index to our list of temps.
	}
	else
		vResult = (*this)[ mFirstUnused++ ];	// Just return the unused one's loc and increase unused counter.
	
	return vResult;
}


/* --------------------------------------------------------------------------------
	ResetUnusedPointer:
		Reset our "first unused" address to zero, declaring all temporaries as
		unused again. Called between every command.
	
	TAKES:
		-
	
	GIVES:
		-
	
	REVISIONS:
		2001-01-18	UK		Documented.
   ----------------------------------------------------------------------------- */

void	TalkTempVarList::ResetUnusedPointer()
{
	mFirstUnused = 0;
}










