/*
 *  XSmartPointer.cpp
 *
 *  Created by Uli Kusterer on Wed Mar 20 2002.
 *  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
 *
 */

#include "XSmartPointer.h"
#include	<stdexcept>
#include	<string>


XSmartPointer::operator char* ()
{
	if( mPointer == NULL )
	{
		throw std::runtime_error( "WARNING: Accessing NULL pointer!" );
		return NULL;
	}
	else
		return mPointer;
}

XSmartPointer::operator long ()
{
	if( mPointer == NULL )
	{
		throw std::runtime_error( "WARNING: Accessing NULL pointer!" );
		return 0L;
	}
	else
		return (long) mPointer;
}

char XSmartPointer::operator* ()
{
	if( mPointer == NULL )
	{
		throw std::runtime_error( "WARNING: Accessing NULL pointer!" );
		return 0;
	}
	else
		return *mPointer;
}

char XSmartPointer::operator-> ()
{
	if( mPointer == NULL )
	{
		throw std::runtime_error( "WARNING: Accessing NULL pointer!" );
		return 0;
	}
	else
		return *mPointer;
}

bool XSmartPointer::operator==(const XSmartPointer& rhs)
{
	return mPointer == rhs.mPointer;
}

bool XSmartPointer::operator==(const int rhs)
{
	return ((long)mPointer) == rhs;
}

bool XSmartPointer::operator==(const long& rhs)
{
	return ((long)mPointer) == rhs;
}

bool XSmartPointer::operator==(const char* rhs)
{
	return (mPointer == rhs);
}

bool XSmartPointer::operator!=(const XSmartPointer& rhs)
{
	return mPointer != rhs.mPointer;
}

bool XSmartPointer::operator!=(const int rhs)
{
	return ((long)mPointer) != rhs;
}

bool XSmartPointer::operator!=(const long& rhs)
{
	return ((long)mPointer) != rhs;
}

bool XSmartPointer::operator!=(const char* rhs)
{
	return( mPointer != rhs );
}

XSmartPointer& XSmartPointer::operator=(const XSmartPointer& val)
{
	mPointer = val.mPointer;
	return *this;
}

XSmartPointer& XSmartPointer::operator=(char* val)
{
	mPointer = val;
	return *this;
}


