#include	"JokerPackage.h"
#include	<stdio.h>
#include	<string>
#include	<sys/stat.h>


/* -----------------------------------------------------------------------------
	MakePackage:
		The only required function of this file. Create a folder and label it
		as a package (aka bundle) the way your OS requires it, then create a
		file of same name inside that folder. If your OS does not support
		packages, just create a _folder_ with a file in it.
	
	TAKES:
		fPath	-	Path for the package (folder) to be created.
	
	GIVES:
		int		-	0 on success, anything else indicates an error.
	
	REVISIONS:
		2002-02-28	UK	Redid generic version by ripping out parts from
						carbon version.
		2001-12-23	UK	Documented.
   -------------------------------------------------------------------------- */

int		MakePackage( const char* fPath )
{
    std::string			mainFPath( fPath );
    size_t				vLastSlash;
    FILE*				vFile;
    
    // Append second copy of folder name to path so we have a path for the package's main file:
    vLastSlash = mainFPath.find_last_of( '/' );
    if( vLastSlash == -1 )
    {
        mainFPath += '/';
        mainFPath.append( fPath );
    }
    else
        mainFPath.append( mainFPath, vLastSlash, mainFPath.length() );	// UK 2002-02-01 - Added mainFPath.length() to satisfy CodeWarrior.
    
    // Make folder and then main file in it:
    if( mkdir( fPath, S_IRWXU | S_IRWXG | S_IRWXO ) != 0 )
        return -1;
    vFile = fopen( mainFPath.c_str(), "w" );
    if( !vFile )
        return -1;	// Indicate an error.
    fclose( vFile );	// Create file and then close it again.
    
	// FIX ME! Here you might need to do some additional magic to label the folder as a package.
    
	return 0;
}