/*
 *  TalkConsole.cpp
 *
 *  Created by Uli Kusterer on Wed Mar 20 2002.
 *
 */

#include "TalkInstructions.h"

/* --------------------------------------------------------------------------------
	HyperGetStdinInstruction:
		Get user input from the console.
	
	HI's FIELDS:
		Result	-	User input
   ----------------------------------------------------------------------------- */

void	HyperGetStdinInstruction( struct HyperInstruction& hi, ValueStack& s,
								TalkCallRecord& vCallRec )
{
	ValueStorage		vEmptyStr;
	char				vUserInputString[512];		// 0.5k should be enough for even long lines
	
	std::cin.getline( vUserInputString, 512 );			// Read one line from console.
	
	vEmptyStr.textType = new TextMunger( vUserInputString );
	std::cout << "INPUT RECEIVED:" << vUserInputString << std::endl;
		
	hi.mResult.SetValue( vEmptyStr, s, VALUE_TYPE_TEXT );
	
	delete vEmptyStr.textType;	// Get rid of this text munger.
}


/* --------------------------------------------------------------------------------
	HyperOutputInstruction:
		The 'put' command w/o destination. Takes the LHS and prints it to the
		console.
	
	HI's FIELDS:
		0		-	Value to output
		Result	-	*undefined*
   ----------------------------------------------------------------------------- */

void	HyperOutputInstruction( struct HyperInstruction& hi, ValueStack& s,
								TalkCallRecord& vCallRec )
{
	ValueStorage	vLHS;
	
	hi.mParam[0].GetValue( vLHS, s, VALUE_TYPE_TEXT );
	std::cout << (*vLHS.textType).String();
	std::cout.flush();
	
	delete vLHS.textType;	// The TextMunger returned by GetValue() belongs to us.
}
