/* ================================================================================
	PROJECT:	JokerLib
	FILE:		JokerLib.r
	PURPOSE:	Rez Header file for JokerLib, the shared library that implements
				an xTalk interpreter.
	COPYRIGHT:	JokerLib and Joker are (c) Copyright 1999-2001 by M. Uli Kusterer,
				all rights reserved.
   ============================================================================= */

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */

#include "Types.r"


/* --------------------------------------------------------------------------------
	Constants:
   ----------------------------------------------------------------------------- */

#define		JOKC_rezTemplateVersion		0

/* Parameter types: */
#define TALK_PARAM_TYPE_INVALID			0	/* Use this to skip direct argument or
												to designate syntactic sugar. */
#define TALK_PARAM_TYPE_EXPRESSION		1	/* Any expression. Not editable. */
#define TALK_PARAM_TYPE_VALUE			2	/* A value that isn't editable. Used
												e.g. for entry <n> of <variable>
												to avoid a precedence mess. */
#define TALK_PARAM_TYPE_CONTAINER		3	/* A value that is editable, e.g.
												variables or entries etc. */
#define TALK_PARAM_TYPE_QUALIFIER		4	/* If the label for this param is
												present, the param is true, else
												false. */
#define TALK_PARAM_TYPE_IDENTIFIER		5	/* Any unquoted identifier.	*/

/* Possible values for mOptional: */
#define TALK_PARAM_IS_OPTIONAL	true
#define TALK_PARAM_IS_REQUIRED	false

/* Values with special meaning for mDestParam:	*/
#define TALK_PARAM_RESULT		-1			/* Store in result.	*/

/* Values with special meaning for mResultParam:	*/
#define TALK_PARAM_IT			-2			/* Store in "it". Will take care "it" is defined. */
#define TALK_PARAM_IGNORE		-3			/* Ignore function result. */



/* --------------------------------------------------------------------------------
	Resource Types:
   ----------------------------------------------------------------------------- */

type 'JOKC'
{
    switch
    {
        case versionZero:
            key integer=0;
			
			/* Command entry parameter. */
            {
				integer;	/* The label to identify this param. This allows arbitrary
								order or optional params. For direct argument this is the
								command name. Specify TOKEN_TYPE_INVALID here for unlabeled
								parameters. */
	TalkEntryParamTypeEnum	mParamType;	/* Invalid to omit direct argument, else the kind of value to
											Be parsed after above token has been encountered. */
	short					mDestParam;	// What param of the instruction to store this value in (one-based).
	bool					mOptional;	/* Set to empty if this parameter is missing and don't complain?
											Be careful here: This is set to an empty string constant, so
											changing a missing optional parameter will likely result in odd
											behaviour. */
	HyperInstrProcPtr		mCommandInstruction;	/* The instruction to generate for this. Set to NULL to
														use the one most recently set. The command entry *must*
														set this, all other params should only set this if they
														cause an entirely different command to be executed. */
};
            }
    };
};

