/* =============================================================================
	
	PROJECT:	Joker
	
	FILE:		GetPartialPath.h
	
	PURPOSE:	Utility functions to get full (=absolute) or partial
				(=relative) pathnames from an FSSpec. This code is roughly
				based on Jim Luther's MoreFiles code, 
	
	COPYRIGHT:	(c) copyright 2002 by M. Uli Kusterer, all rights reserved.
	
	AUTHORS:	UK	-	M. Uli Kusterer, <witness@weblayout.com>
	
	REVISIONS:
		2002-03-01	UK	Documented.
	
   ========================================================================== */

#ifndef GET_PARTIAL_PATH_H
#define GET_PARTIAL_PATH_H

/* -----------------------------------------------------------------------------
	Headers:
   -------------------------------------------------------------------------- */

#include	<MacTypes.h>
#include	<Files.h>


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
	Prototypes:
   -------------------------------------------------------------------------- */

void	PrependPString( Str255 prependString, Str255 str );
OSErr	FSpGetPartialPath( const FSSpec *spec, long dirID, Str255 fullPath );
OSErr	FSpGetFullPath( const FSSpec *spec,	Str255 outPath );
OSErr	FSpIsAFolder( const FSSpec* tempSpec, Boolean *isFolder );




#ifdef __cplusplus
}
#endif

#endif /*GET_PARTIAL_PATH_H*/