/*	***************************************************************************

	PROJECT:	Joker.mcp
	
	FILE:		JokerResources.r
	
	PURPOSE:	The definitions of the resources for the Macintosh port of
				Joker.
		
	COPYRIGHT:	(C) Copyright 2001 by M. Uli Kusterer, all rights reserved.
				
	REACH ME AT:
				E-MAIL:		witness@weblayout.com
				URL:		http://www.weblayout.com/witness
	
	
	REVISIONS:
		2001-01-17	UK		Created based on JokerAETE.r.
				
	************************************************************************ */

/* --------------------------------------------------------------------------------
	Headers:
   ----------------------------------------------------------------------------- */
   
#include "Types.r"		/* must come before AEUserTermTypes.r */
#include "AEUserTermTypes.r"
#include "AppleEvents.r"
#include "AEObjects.r"
#include "AERegistry.r"


/* --------------------------------------------------------------------------------
	Resource Types:
   ----------------------------------------------------------------------------- */

// Resource template, used by ResEdit to give a clear text display of a resource.
type 'TMPL'
{
	array TypesArray
	{
		pstring;
		literal longint;
	};
};

// C-String list. A packed array of C-Strings with a short at the start telling how many we have.
type 'CST#'
{
        integer = $$Countof(StringArray);
        array StringArray
        {
                cstring;                                        /* String               */
        };
};


/* --------------------------------------------------------------------------------
	Template for "CST#" resources so ResEdit lets the user edit these resources:
   ----------------------------------------------------------------------------- */
   
resource 'TMPL' ( 128, "CST#" )
{
	{
		"Strings:",
		'OCNT',
		"*****",
		'LSTC',
		"String:",
		'CSTR',
		"*****",
		'LSTE'
	}
};


/* --------------------------------------------------------------------------------
	"CST#" resource ID 128, containing our compiler flags since there's no
	console on classic MacOS where they can be specified:
   ----------------------------------------------------------------------------- */
   
resource 'CST#' ( 128, "Compiler Flags" )
{
	{
		"-u",	// Allow unquoted string literals?
		"on",		// (on or off)
		"-v",	// Make unquoted string literals variables with their name in them, not constants?
		"on",		// (on or off)
		"-f",	// Distinguish between functions and commands?
		"on",		// (on or off)
		"-e",	// Support escape sequences in strings?
		"on"		// (on or off)
	}
};


/* --------------------------------------------------------------------------------
	AppleEvent Dictionary for Joker so we can test Apple Event capabilities using
	AppleScript:
   ----------------------------------------------------------------------------- */
   
resource 'aete' (0, "Joker Dictionary", sysheap)
{
	0x01,
	0x00,
	english,
	roman,
	{
		"Joker Suite",
		"Events specific to Joker.",
		'JOKR',
		1,
		1,
		{
			"show off",
			"Just so we can show off.",
			'JOKR',
			'dumy',
			noReply,
			"",
			replyoptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			noParams,
			"no direct parameter required",
			directParamoptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			{
			},
			"danceSome",
			"for testing only.",
			'JOKR',
			'danc',
			noReply,
			"",
			replyoptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			noParams,
			"no direct parameter required",
			directParamoptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			{
				"every",
				'evry',
				'shor',
				"How often will you miss the step?",
				required,
				singleItem,
				notEnumerated,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				"saying",
				'sayi',
				'TEXT',
				"What you\'ll say when missing the step.",
				required,
				singleItem,
				notEnumerated,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved,
				reserved
			}
		},
		{
		},
		{
		},
		{
		},
		"Required Suite",
		"Terms that every application should support",
		'reqd',
		1,
		1,
		{
			"quit",
			"Quit application",
			'aevt',
			'quit',
			noReply,
			"",
			replyoptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			noParams,
			"no direct parameter required",
			directParamoptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			{
			},
			"run",
			"Sent to an application when it is double-clicked",
			'aevt',
			'oapp',
			noReply,
			"",
			replyoptional,
			singleItem,
			notEnumerated,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			noParams,
			"no direct parameter required",
			directParamoptional,
			singleItem,
			notEnumerated,
			changesState,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			reserved,
			{
			}
		},
		{
		},
		{
		},
		{
		}
	}
};
