#include	"JokerPackage.h"
#include	<string.h>
#include	<stdio.h>
#include	<Files.h>
#include	<Aliases.h>
#include	<Script.h>
#include	<Resources.h>
#include	"MacUtils.h"


/* FSpGetDirID returns the directory ID number for the directory
	pointed to by the file specification record *spec.  */
OSErr FSpGetDirID(FSSpec *spec, long *theDirID) {
	CInfoPBRec cat;
	OSErr err;
	BlockZero(&cat, sizeof(cat));
	cat.dirInfo.ioNamePtr = spec->name;
	cat.dirInfo.ioVRefNum = spec->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = spec->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) return err;
	if ((cat.dirInfo.ioFlAttrib & 16) == 0) return paramErr;
	*theDirID = cat.dirInfo.ioDrDirID;
	return noErr;
}

/* UpdateRelativeAliasFile updates the alias file located at aliasDest referring to the targetFile.
	relative path information is stored in the new file.  It is appropriate for targetFile to refer
	to either a file or a folder.  */
OSErr UpdateRelativeAliasFile(FSSpec *theAliasFile, FSSpec *targetFile, Boolean createIfNecessary, Boolean makeRelative) {
	CInfoPBRec cat;
	FInfo fndrInfo;
	AliasHandle theAlias;
	Boolean wasChanged;
	short rsrc;
	OSErr err;
	 	/* set up locals */
	rsrc = -1;
		/* set up the Finder information record */
	BlockZero(&fndrInfo, sizeof(fndrInfo));
	BlockZero(&cat, sizeof(cat));
	cat.dirInfo.ioNamePtr = targetFile->name;
	cat.dirInfo.ioVRefNum = targetFile->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = targetFile->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) goto bail;
	if ((cat.dirInfo.ioFlAttrib & 16) == 0) {	/* file alias */
		switch (cat.hFileInfo.ioFlFndrInfo.fdType) {
			case 'APPL': fndrInfo.fdType = kApplicationAliasType; break;
			case 'APPC': fndrInfo.fdType = kApplicationCPAliasType; break;
			case 'APPD': fndrInfo.fdType = kApplicationDAAliasType; break;
			default: fndrInfo.fdType = cat.hFileInfo.ioFlFndrInfo.fdType; break;
		}
		fndrInfo.fdCreator = cat.hFileInfo.ioFlFndrInfo.fdCreator;
	} else {
		fndrInfo.fdType = kContainerFolderAliasType;
		fndrInfo.fdCreator = 'MACS';
	}
	fndrInfo.fdFlags = kIsAlias;
	 	/* set the file information or the new file */
	err = FSpSetFInfo(theAliasFile, &fndrInfo);
	if ((err == fnfErr) && createIfNecessary) {
		FSpCreateResFile( theAliasFile, fndrInfo.fdCreator, fndrInfo.fdType, smSystemScript);
		if ((err = ResError()) != noErr) goto bail;
		err = FSpSetFInfo( theAliasFile, &fndrInfo);
		if (err != noErr) goto bail;
	} else if (err != noErr) goto bail;
	 	/* save the resource */
	rsrc = FSpOpenResFile(theAliasFile, fsRdWrPerm);
	if (rsrc == -1) { err = ResError(); goto bail; }
	UseResFile(rsrc);
	theAlias = (AliasHandle) Get1IndResource(rAliasType, 1);
	if (theAlias != NULL) {
		err = UpdateAlias( makeRelative ? theAliasFile : NULL, targetFile, theAlias, &wasChanged);
		if (err != noErr) goto bail;
		if (wasChanged)
			ChangedResource((Handle) theAlias);
	} else {
		err = NewAlias(makeRelative ? theAliasFile : NULL, targetFile, &theAlias);
		if (err != noErr) goto bail;
		AddResource((Handle) theAlias, rAliasType, 0, theAliasFile->name);
		if ((err = ResError()) != noErr) goto bail;
	}
	CloseResFile(rsrc);
	rsrc = -1;
		/* done */
	return noErr;
 bail:
	if (rsrc != -1) CloseResFile(rsrc);
	return err;
 }
 
/*void	JokerCStringToP( const char* src, Str255 dest )	// Already in MacTalkURLValue
{
	dest[0] = strlen(src);
    memmove( dest+1, src, dest[0] );
}*/


int		MakePackage( const char* fPath )
{
	FSSpec				packFoldr,
						packFile;
    FSSpec				*packageFolder = &packFoldr;
	CInfoPBRec			cat;
	OSStatus			err;
	Str255				name;
	short				x;
    
    // Make FSSpec for our package folder and create it:
    JokerCStringToP( fPath, name );
    err = FSMakeFSSpec( 0, 0, name, &packFoldr );
	if (err != noErr && err != fnfErr) return err;
    packFile = packFoldr;
    err = FSpDirCreate( &packFoldr, smSystemScript, &packFile.parID );
	if (err != noErr) return err;
    
    // Create main file in folder:
	for( x = strlen(fPath); (x >= 0) && (fPath[x] != ':'); x-- )
		;
	x++;
	if( fPath[x] == ':' )
		x++;
	packFile.name[0] = strlen(fPath) -x;
	memmove( packFile.name+1, fPath+x, packFile.name[0] );
	err = FSpCreate( &packFile, '????', '????', smSystemScript );
	if (err != noErr) return err;
    
	// Set the package flag:
	cat.dirInfo.ioNamePtr = packageFolder->name;
	cat.dirInfo.ioVRefNum = packageFolder->vRefNum;
	cat.dirInfo.ioFDirIndex = 0;
	cat.dirInfo.ioDrDirID = packageFolder->parID;
	err = PBGetCatInfoSync(&cat);
	if (err != noErr) return err;
	cat.dirInfo.ioDrDirID = packageFolder->parID;
	cat.dirInfo.ioDrUsrWds.frFlags |= kHasBundle;
	err = PBSetCatInfoSync(&cat);
	if (err != noErr) return err;
    
	return noErr;
}