/* =============================================================================
	
	PROJECT:	Joker
	
	FILE:		MacUtils.c
	
	PURPOSE:	Some neat utility functions used across the Mac port of
				Joker.
	
	COPYRIGHT:	(c) copyright 2002 by M. Uli Kusterer, all rights reserved.
	
	AUTHORS:	UK	-	M. Uli Kusterer, <witness@weblayout.com>
	
	REVISIONS:
		2002-03-01	UK	Tidied up comments.
	
   ========================================================================== */

#include	"MacUtils.h"
#include	"string.h"


/* -----------------------------------------------------------------------------
	JokerCStringToP:
		Copy a zero-terminated C-string to a P-String with a length byte.
		
		We could use c2pstr but that's only available pre-carbon. We could use
		CopyCStringToPascal, but that's only available in carbon. So we just
		roll our own.
	
	TAKES:
		cstr	-	A zero-terminated C string to be converted.
		
	GIVES:
		outStr	-	This string is set to a Pascal-string-version (first byte
					is length byte) of cstr.
	
	REVISIONS:
		2002-03-01	UK	Documented params.
   -------------------------------------------------------------------------- */

void	JokerCStringToP( const char* cstr, unsigned char* outStr )
{
	outStr[0] = strlen(cstr);
	
	memmove( outStr +1, cstr, outStr[0] );
}


/* -----------------------------------------------------------------------------
	JokerPStringToC:
		Copy a P-String with a length byte to a zero-terminated C-string.
		
		We could use p2cstr but that's only available pre-carbon. We could use
		CopyPascalStringToC, but that's only available in carbon. So we just
		roll our own.
	
	TAKES:
		pstr	-	A byte length-counted Pascal string to be converted.
		
	GIVES:
		outStr	-	This string is set to a zero-terminated C-string-version of
					pstr.
	
	REVISIONS:
		2002-03-01	UK	Documented params, moved here from MacTalkInstructions.
   -------------------------------------------------------------------------- */

void	JokerPStringToC( const unsigned char* pstr, char* outStr )
{
	unsigned char		len = pstr[0];
	
	memmove( outStr, pstr +1, len );
	outStr[len] = 0;	// Terminate C string.
}