<?php
/*

Copyright (c) 2006 Tyler J. Vano

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

*/

class token
{
	const TOKEN_STATE_WHITESPACE		= 0;
	const TOKEN_STATE_IDENTIFIER		= 1;
	const TOKEN_STATE_STRING			= 2;
	const TOKEN_STATE_OPERATOR			= 3;
	
	const OPERATOR_BINARY				= 0;
	const OPERATOR_UNARY				= 1;
	const OPERATOR_TERNARY				= 2;
	
	/* private */
	
	private $token_type = "";
	private $token_value = "";
	private $token_offset = "";
	
	/* public */
	
	public function __construct( $type = "", $value = "", $offset = "" )
	{
		$this->token_type = $type;
		$this->token_value = $value;
		$this->token_offset = $offset;
	}
	
	public function set_token_type( $new_token_type )
	{
		$this->token_type = $new_token_type;
	}
	
	public function set_token_value( $new_token_value )
	{
		$this->token_value = $new_token_value;
	}
	
	public function set_token_offset( $new_token_offset )
	{
		$this->token_offset = $new_token_offset;
	}
	
	public function get_token_type( )
	{
		return $this->token_type;
	}
	
	public function get_token_value( )
	{
		return $this->token_value;
	}
	
	public function get_token_offset( )
	{
		return $this->token_offset;
	}
	
}

class token_list
{
	/* private */
	
	private $tokenlist = array();
	private $tokenindex = 0;
	
	/* public */
	
	public function __construct( $tokens = "" )
	{
		if ( is_array ( $token ) )
		{
			$this->tokenlist = tokens;
		}
		$this->tokenindex = 0;
	}
	
	public function read_token_at ( $token_loc = "", $readlength = 1 )
	{		
		return array_slice(
			$this->tokenlist,
			( 
				( is_numeric( $token_loc )
				? $token_loc
				: $this->tokenindex
			),
				$readlength
		);
	}
	
	public function reset( )
	{
		$$this->tokenindex = 0;
	}
	
	public function advance_to ( $token_loc )
	{
		$this->tokenindex = $token_loc;
	}
	
	public function get_next_token( $readlength = 1 )
	{
		$newarray = $this->read_token_at( $this->tokenindex, $readlength );
		
		$this->tokenindex += $readlength;
		
		return $newarray;
	}
	
	public function get_previous_token( $readlength = 1 )
	{
		$newarray = $this->read_token_at( $this->tokenindex - $readlength, $readlength );
		
		$this->tokenindex -= $readlength;
		
		return $newarray;
	}	
	
	public function read_next_token( $readlength = 1 )
	{
		return $this->read_token_at( $this->tokenindex, $readlength );
	}
	
	public function read_previous_token( $readlength = 1 )
	{
		return $this->read_token_at( $this->tokenindex - $readlength, $readlength );
	}
	
	public function set_token( $location, $newtoken, $overwritelength = 1 )
	{
		array_splice( $this->$tokenlist[ $location ], $location, $overwritelength, $newtoken );
	}
	
	public function delete_token( $location, $deletelength = 1 )
	{
		array_splice( $this->tokenlist, $location, $deletelength );
	}
	
	public function append_token ( $newtoken )
	{
		array_push( $this->tokenlist, $newtoken );
	}
	
}

class tokenizer
{
	/* private */
	
	private $operatorChars = array(
			
			"@", ",", "+", "-", "/",
			">", "&", "<", "=", "^",
			"(", ")", "'", "[", "]",
			"*"
		);
		
	private $whiteSpaceChars = array ( " ", "\t", "\n", "\r" );
	
	/* public */
	
	public __construct( )
	{
		;
	}
	
	public tokenize ( $tokenstring )
	{
		$tokenstate = token::TOKEN_STATE_WHITESPACE;
		$current_token = new token();
		$alltokens = new token_list();
	
	
		for( $i = 0; $i < strlen( $tokenstring ), $i++ )
		{
		
			$current_char = $tokenstring[$i];
			$operator_offset = array_search( $current_char, $this->operatorChars );
		
			switch( $tokenstate )
			{
				case token::TOKEN_STATE_WHITESPACE:
				
					if ( ! in_array( $current_char, $this->whiteSpaceChars ) )
					{
						if ( $current_char == "\"" )
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_WHITESPACE, "", $i );
						}
						else if ( $operator_offset )
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_OPERATOR, $current_char, $i );
						}
						else
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_IDENTIFIER, $current_char, $i );
						}
					}
					break;
					
				case token::TOKEN_STATE_STRING:
					
					if ( $current_char == "\"" )
					{
						$alltokens->append_token( $current_token );
						$current_token = new token( $tokenstate = token::TOKEN_STATE_WHITESPACE );
					}
					else
					{
						$current_token->set_token_value( $current_token->get_token_value() . $current_char );
					}
					break;
					
				case token::TOKEN_STATE_IDENTIFIER:
				
					if ( in_array( $current_char, $this->whiteSpaceChars ) || $current_char == "\"" || $operator_offset )
					{
					
						// $current_token->set_token_value( strtolower( $current_token->get_token_value() ) );
						
						$alltokens->append_token( $current_token );
						
						if ( $current_char == "\"" )
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_STRING, "", $i );
						}
						else if ( $operator_offset )
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_OPERATOR, $current_char, $i );
						}
						else
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_WHITESPACE );
						}
					
					}
					else
					{
						$current_token->set_token_value( $current_token->get_token_value() . $current_char );
					}
					break;
					
				case token::TOKEN_STATE_OPERATOR:
				
					if ( ! $operator_offset )
					{
						
						$alltokens->append_token( $current_token );
						
						if ( $current_char == "\"" )
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_WHITESPACE, "", $i );
						}
						else if ( $operator_offset )
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_OPERATOR, $current_char, $i );
						}
						else
						{
							$current_token = new token( $tokenstate = token::TOKEN_STATE_IDENTIFIER, $current_char, $i );
						}
						
					}
					else
					{
						if (    $current_token->get_token_value() == ">="
							 || $current_token->get_token_value() == "<="
							 || $current_token->get_token_value() == "<>" )
						{
							$alltokens->append_token( $current_token );
							$current_token = new token( token::TOKEN_STATE_OPERATOR, $current_char, $i );
						}
						else if (
							( ( $current_char == "=" ) && $tokenstring[ $i - 1 ] == ">" || $tokenstring[ $i - 1 ] == "<" )
							|| ( ( $current_char == "&" ) && $tokenstring[ $i - 1 ] == "&" )
							|| ( ( $current_char == ">" ) && $tokenstring[ $i - 1 ] == "<" )
							|| ( ( $current_char == "-" ) && $tokenstring[ $i - 1 ] == "-" ) )
						{
							$current_token->set_token_value( $current_token->get_token_value() . $current_char );
						}
						else
						{
							$alltokens->append_token( $current_token );
							
							$current_token = new token( token::TOKEN_STATE_OPERATOR, $current_char, $i );
						}
						
					}
				
					break;
					
			}
		}
		
		if ( $tokenstate == token::TOKEN_STATE_IDENTIFIER || $tokenstate == token::TOKEN_STATE_STRING || $tokenstate == token::TOKEN_STATE_OPERATOR )
		{
			$alltokens->append_token( $current_token );
			$current_token = new token();
		}
		
		return $alltokens;
	}
	
}
$x = new token( token::TOKEN_STATE_IDENTIFIER, "gay", 3 );
$a = new token_list();

$a->append_token( $x );
print_r( $a );

?>