<?php
/*

Copyright (c) 2006 Tyler J. Vano

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

*/

define( "TOKEN_STATE_WHITESPACE",	"0" );
define( "TOKEN_STATE_IDENTIFIER",		"1" );
define( "TOKEN_STATE_STRING",			"2" );
define( "TOKEN_STATE_OPERATOR",		"3" );

define( "OPERATOR_BINARY",				"0" );
define( "OPERATOR_UNARY", 				"1" );

function tryLog ( $something )
{
//	echo $something;
}

function tokenize( $tokenizeSomething )
{
	$state = TOKEN_STATE_WHITESPACE;

	$operatorChars = array( "@", ",", "+", "-", "/", "<", "&", ">", "=", "^", "(", ")", "'", "[", "]", "*" );
	$whiteSpaceChars = array( " ", "\t" );

	$curToken = array ( "value" => "", "type" => "", "offset" => "" );
	
	$backupTokens = array();
	$symbols = array();

	for ( $i = 0; $i < strlen( $tokenizeSomething ); $i++ )
	{
		$curChar = $tokenizeSomething[$i];
		$opOffset = array_search( $curChar, $operatorChars );

		// Okay, so first we switch on the state, and
		// behave differently depending on what state
		// we're in. We start out as whitespace, because
		// we want to know when the first token starts.
		
		switch ( $state )
		{
		
			case TOKEN_STATE_WHITESPACE:
				tryLog (  "Skipping whitespace...<br/>" );	
				if ( ! in_array( $curChar, $whiteSpaceChars ) ) // No whitespace? We just started an identifier!
				{
					tryLog (  "Found the start of an something: " . $curChar . "<br/>" );
					if ( $curChar == '"' )
					{
						tryLog (  "It's a string.<br/>" );
						$curToken["type"] = $state = TOKEN_STATE_STRING;
						$curToken["offset"] = $i;
					}
					else if ( $opOffset )
					{
						tryLog (  "It's an operator.<br/>" );
						$curToken["type"] = $state = TOKEN_STATE_OPERATOR;
						$curToken["value"] .= $curChar;
						$curToken["offset"] = $i;
					}
					else
					{
						tryLog (  "It's an identifier.<br/>" );
						$curToken["type"]  = $state = TOKEN_STATE_IDENTIFIER;	 // Remember state change.
						$curToken["value"] .= $curChar;					   		// Remember this char.
						$curToken["offset"] = $i;							   // Remember token position.
					}
					
				}
				// else we don't care about whitespace and just forget it.
				break;
				
			case TOKEN_STATE_STRING:
				tryLog ( "Continuing string read..." );
				if ( $curChar == '"' )
				{
					tryLog (  "End of string found. Saving...<br/>" );
					array_push( $symbols, $curToken );
					$curToken = array ( "value" => "", "type" => "", "offset" => "" );
					$curToken["type"] = $state = TOKEN_STATE_WHITESPACE;
				}
				else
				{
					tryLog (  "Adding character " . $curChar . "<br/>" );
					$curToken["value"] .= $curChar;
				}
				break;
				
			case TOKEN_STATE_IDENTIFIER:
				tryLog (  "Reading identifier...<br/>" );
				if ( in_array( $curChar, $whiteSpaceChars ) || $curChar == '"' || $opOffset ) // Hit white space, operator? End of token!
				{
					
					tryLog (  "We've hit the end of the identifier. Saving...<br/>" );
					
					array_push( $symbols, $curToken );
										
					$curToken = array ( "value" => "", "type" => "", "offset" => "" );
					
					if ( $curChar == '"' )
					{
						tryLog (  "Starting a new string...<br/>" );
						$curToken["type"] = $stage = TOKEN_STATE_STRING;
						$curToken["offset"] = $i;
					}
					else if ( $opOffset )
					{
						tryLog (  "Starting a new operator ( " . $curChar . " )...<br/>" );
						$curToken["type"] = $state = TOKEN_STATE_OPERATOR;
						$curToken["value"] .= $curChar;
						$curToken["offset"] = $i;
					}
					else
					{
						$curToken["type"] = $state = TOKEN_STATE_WHITESPACE;
					}
				}
				else
				{
					tryLog (  "Adding to identifier: " . $curChar . "<br/>" );
					$curToken["value"] .= $curChar; // Not whitespace? Add char to token!
				}
				break;
				
			case TOKEN_STATE_OPERATOR:
				tryLog (  "Continuing operator read...<br/>" );
				if ( ! $opOffset )
				{
					tryLog (  "End of operator found.<br/>" );
					// It's not an operator. End the token.
					array_push( $symbols, $curToken );
					$curToken = array ( "value" => "", "type" => "", "offset" => "" );
					
					if ( $curChar == '"' )
					{
						tryLog( "Starting a new string...<br/>" );
						$curToken["type"] = $state = TOKEN_STATE_STRING;
						$curToken["offset"] = $i;
					}
					else if ( in_array( $curChar, $whiteSpaceChars ) )
					{
						tryLog( "Found whitespace.<br/>" );
						$state = TOKEN_STATE_WHITESPACE;
					}
					else
					{
						tryLog( "Starting a new identifier ( " . $curChar . " )...<br/>" );
						$curToken["type"] = $state = TOKEN_STATE_IDENTIFIER;
						$curToken["offset"] = $i;
						$curToken["value"] .= $curChar;
					}
				}
				else
				{
					if ( $curToken["value"] == ">=" || $curToken["value"] == "<=" || $curToken["value"] == "&&" || $curToken["value"] == "<>" || $curToken["value"] == "--" )
					{
						array_push( $symbols, $curToken );
						$curToken = array ( "value" => "", "type" => "", "offset" => "" );
						
						$curToken["type"] == TOKEN_STATE_OPERATOR;
						$curToken["offset"] == $i;
						$curToken["value"] .= $curChar;
					}
					else if
						(
							( ( $curChar == '=' ) && $tokenizeSomething[ $i - 1 ] == '>' || $tokenizeSomething[ $i - 1 ] == '<' )
							|| ( ( $curChar == '&' ) && $tokenizeSomething[ $i - 1 ] == '&' )
							|| ( ( $curChar == '>' ) && $tokenizeSomething[ $i - 1 ] == '<' )
							|| ( ( $curChar == '-' ) && $tokenizeSomething[ $i - 1 ] == '-' )
						)
					{
						$curToken["value"] .= $curChar;
					}
					else
					{
						array_push( $symbols, $curToken );
						$curToken = array ( "value" => "", "type" => "", "offset" => "" );
						
						$curToken["type"] = TOKEN_STATE_OPERATOR;
						$curToken["offset"] = $i;
						$curToken["value"] .= $curChar;
					}
					
				}
				
			break;
			
		}
		
	}
	
	if ( $state = TOKEN_STATE_IDENTIFIER || $state = TOKEN_STATE_STRING || $state == TOKEN_STATE_OPERATOR )
	{
						array_push( $symbols, $curToken );
						$curToken = array ( "value" => "", "type" => "", "offset" => "" );
	}
	
	// Smart Re-Tokenizer
	
	// Copy symbols to backupTokens

	$backupTokens = $symbols;

	$symbols = array();
	
	for ( $i = 0; $i < count( $backupTokens ); $i++ )
	{
		if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 4 )
		&& $backupTokens[ $i ]["value"] == "there"
		&& $backupTokens[ $i + 1 ]["value"] == "is"
		&& $backupTokens[ $i + 2 ]["value"] == "not"
		&& ( $backupTokens[ $i + 3 ]["value"] == "a"
		|| $backupTokens[ $i + 3 ]["value"] == "an" ) )
		{
			array_push( $symbols, array ( "value" => "there is not a", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 3;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "there"
			&& $backupTokens[ $i + 1 ]["value"] == "is"
			&& (
				   $backupTokens[ $i + 2 ]["value"] == "a"
				|| $backupTokens[ $i + 2 ]["value"] == "an"
			) )
		{
			array_push( $symbols, array ( "value" => "there is a", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "there"
			&& $backupTokens[ $i + 1 ]["value"] == "is"
			&& $backupTokens[ $i + 2 ]["value"] == "no" )
		{
			array_push( $symbols, array ( "value" => "there is no", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "does"
			&& $backupTokens[ $i + 1 ]["value"] == "not"
			&& $backupTokens[ $i + 2 ]["value"] == "contain" )
		{
			array_push( $symbols, array ( "value" => "does not contain", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "is"
			&& $backupTokens[ $i + 1 ]["value"] == "not"
			&& $backupTokens[ $i + 2 ]["value"] == "within" )
		{
			array_push( $symbols, array ( "value" => "is not within", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "is"
			&& $backupTokens[ $i + 1 ]["value"] == "not"
			&& $backupTokens[ $i + 2 ]["value"] == "in" )
		{
			array_push( $symbols, array ( "value" => "is not in", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "there"
			&& $backupTokens[ $i + 1 ]["value"] == "is"
			&& $backupTokens[ $i + 2 ]["value"] == "no" )
		{
			array_push( $symbols, array ( "value" => "there is no", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "is"
			&& $backupTokens[ $i + 1 ]["value"] == "not"
			&& (
				   $backupTokens[ $i + 2 ]["value"] == "a"
				|| $backupTokens[ $i + 2 ]["value"] == "an"
			) )
		{
			array_push( $symbols, array ( "value" => "is not a", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 3 )
			&& $backupTokens[ $i ]["value"] == "isn"
			&& $backupTokens[ $i + 1 ]["value"] == "'"
			&& $backupTokens[ $i + 2 ]["value"] == "t" )
		{
			array_push( $symbols, array ( "value" => "is not", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 2;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 2 )
			&& $backupTokens[ $i ]["value"] == "is"
			&& $backupTokens[ $i + 1 ]["value"] == "not" )
		{
			array_push( $symbols, array ( "value" => "is not", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 1;
		}
		else if ( ( ( count ( $backupTokens ) - 1 - $i ) >= 2 )
			&& $backupTokens[ $i ]["value"] == "is"
			&& $backupTokens[ $i + 1 ]["value"] == "in" )
		{
			array_push( $symbols, array ( "value" => "is in", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
			$i += 1;
		}
		else if ( $backupTokens[$i]["value"] == "and" )
		{
			array_push( $symbols, array ( "value" => "and", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
		}
		else if ( $backupTokens[$i]["value"] == "or" )
		{
			array_push( $symbols, array ( "value" => "or", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
		}
		else if ( $backupTokens[$i]["value"] == "is" )
		{
			array_push( $symbols, array ( "value" => "is", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
		}
		else if ( $backupTokens[$i]["value"] == "not" )
		{
			array_push( $symbols, array ( "value" => "not", "offset" => $backupTokens[ $i ]["offset"], "type" => TOKEN_STATE_OPERATOR ) );
		}
		else
		{
			array_push( $symbols, $backupTokens[ $i ] );
		}
	}
	
	return $symbols;
	
}

function compileLine( $tokens )
{
		
	switch ( $tokens[ 0 ][ "value" ] )
	{
		case "on":
		
			$source .= "function " . $tokens[ 1 ][ "value" ] . " ( ";
			
			if ( count ( $tokens ) > 2 )
			{			
				for ( $i = 2; $i < count( $tokens ); $i += 2 )
				{
					$source .= $tokens[ $i ][ "value" ];
									
					if ( $i < count( $tokens ) - 1 )
					{
						 $source .= ", ";
					}
					else
					{
						$source .= " )\n{\n";
					}
				}
			}
			else
			{
				$source .= " )\n{\n";
			}
			break;
			
		case "global":
			for ( $i = 1; $i < count( $tokens ); $i += 2 )
			{
				$source .= "global $" . $tokens[ $i ][ "value" ] . ";\n";
			}
			break;
		
		case "answer":
			$expr = fetchExpression( $tokens, $i + 1 );
			$i = $expr[ "position" ];
			$source .= "alert( " . $expr[ "result" ] . " );\n";
			break;
		
		case "put":
			$expr = fetchExpression( $tokens, $i + 1 );
			$i = $expr[ "position" ];
			if ( $expr[ "position" ] >= count( $tokens ) - 1 )
			{
				// That's the end of the line, so this is an output put.
				$source .= "alert( " . $expr[ "result" ] . " );\n";
			}
			else
			{
				// Copy Value
				$container = fetchContainer( $tokens, $i + 1 );
				$source .= $container[ "result" ] . " = " . $expr[ "result" ] . ";\n";
			}
			break;
			
		case "end":

			$source = "}\n";
		
			// Minor pretty-printing.
			if ( $tokens[ 1 ]["value"] != "if" && $tokens[ 2 ]["value"] != "repeat" )
			{
				$source .= "\n";
			}
			
			break;
		
	}
	
	return $source;
	
}

function precedence ( $operator )
{
	if ( array_search( $operator, array( "", "not", "^" ) ) != false )
	{
		return 7;
	}
	
	if ( array_search( $operator, array( "", "*", "/", "div", "mod" ) ) != false )
	{
		return 6;
	}
	
	if ( array_search( $operator, array( "", "+", "-" ) ) != false )
	{
		return 5;
	}
	
	if ( array_search( $operator, array( "", "<", ">", "<=", ">=" ) ) != false )
	{
		return 4;
	}
	
	if ( array_search( $operator, array( "", "=", "is", "<>", "is not", "isn't", ) ) != false )
	{
		return 3;
	}
	
	if ( array_search( $operator, array( "", "&", "&&" ) ) != false )
	{
		return 2;
	}
		
	if ( array_search( $operator, array( "", "is in", "is not in", "does not contain", "contains" ) ) != false )
	{
		return 1;
	}
	
	if ( array_search( $operator, array( "", "and", "or" ) ) != false )
	{
		return 0;
	}




}

function operatorToFactor( $operator )
{
	$operators =	array( "", "+", "-", "*", "/", "^", "&", "&&" );
	$opfunctions =	array( "", "hpop__binaryAdd", "hpop__binarySubtract", "hpop__binaryMultiply", "hpop__binaryDivide", "hpop__binaryExp", "hpop__binaryConcat", "hpop__binaryConcat2" );
		
	if ( array_search( $operator, $operators ) != false )
		return $opfunctions[ array_search( $operator, $operators ) ];
	else
		return false;
}

function fetchExpression( $tokens, $start )
{
	
	$expressionStack = array();
	$expressionStack2 = array();
	$operatorStack = array();
	$precedenceStack = array();
	
	$pflag = false;
	
	$curFactor = fetchFactor( $tokens, $start );
	
	$i = $curFactor["position"];
	
	if ( ! operatorToFactor( $tokens[$i-1]["value"] ) )
	{
		return array( "result" => $curFactor["result"], "position" => $curFactor["position"] );
	}
	
	$operator = $tokens[$i-1]["value"];
	
	array_push( $expressionStack, $curFactor["result"] );
	array_push( $expressionStack2, operatorToFactor( $operator ) . "( " );
	array_push( $precedenceStack, "1" );
	array_push( $operatorStack, $operator );
			
	while( 1 )
	{
		
		
		$oldFactor = $curFactor;
		
		$oldOperator = $operator;
		
		$curFactor = fetchFactor( $tokens, $i );
	
		$i = $curFactor["position"];
				
		if ( ! operatorToFactor( $tokens[$i-1]["value"] ) )
		{
			break;
		}
	
		$operator = $tokens[$i-1]["value"];
		
		$topOperator = array_pop( $operatorStack );
		array_push( $operatorStack, $topOperator );
		
		if ( precedence( $operator ) > precedence( $oldOperator ) )
		{
			array_push( $precedenceStack, "1" );
			
			array_push( $expressionStack, $curFactor["result"] );
			
			array_push( $expressionStack2, operatorToFactor( $operator ) . "( " );

			array_push( $operatorStack, $operator );
			
			$pflag = true;
		}
		else if ( precedence( $operator ) < precedence( $topOperator ) )
		{
			
			$thisExpr = array_pop ( $expressionStack );
			
			$thisExpr .= ", " . $curFactor["result"] . " ) ";
			
			array_push( $expressionStack, $thisExpr );
			
			while( precedence( $operator ) < precedence( $topOperator ) )
			{
				$parenCount = array_pop( $precedenceStack );
				$thisExpr = array_pop( $expressionStack );
				
				$thisExpr2 = array_pop( $expressionStack );
				$thisExpr3 = array_pop( $expressionStack2 );
				$thisExpr2 .= $thisExpr3 . $thisExpr;
						
				array_push( $expressionStack, $thisExpr2 );
				
				array_pop( $operatorStack );
				
				array_pop( $operatorStack );
				
				$topOperator = array_pop( $operatorStack );
				array_push( $operatorStack, $topOperator );
			}
			
			$thisExpr = array_pop( $expressionStack2 );
			
			$thisExpr = operatorToFactor( $operator ) . " ( " . $thisExpr;
			
			array_push( $expressionStack2, $thisExpr );
			
			
			$pflag = false;
			
		}
		else
		{
			$tempExpr = array_pop( $expressionStack );
			$tempExpr2 = array_pop( $expressionStack2 );
			if ( $pflag )
				array_push( $expressionStack, $tempExpr . ", " . $curFactor["result"] . " ) " );
			else
				array_push( $expressionStack, $tempExpr . ", " . $curFactor["result"] . " ) " );
			
			$pflag = false;
			
			array_push( $expressionStack2, operatorToFactor( $operator ) . "( " . $tempExpr2 );
			array_push( $precedenceStack, array_pop( $precedenceStack ) + 1 );
		}		
		
		$tempExpr = array_pop( $expressionStack );
		array_push( $expressionStack, $tempExpr );
					
	}
	
	$thisExpr = array_pop( $expressionStack );
	
	$thisExpr .= ", " . $curFactor["result"] . " ) ";
	
	array_push( $expressionStack, $thisExpr );
	
	while( count( $operatorStack ) > 1 )
	{
		$parenCount = array_pop( $precedenceStack );
		$thisExpr = array_pop( $expressionStack );
		
		$thisExpr2 = array_pop( $expressionStack );
		$thisExpr3 = array_pop( $expressionStack2 );
		$thisExpr2 .= ", " . $thisExpr3 . $thisExpr . " ) ";
				
		array_push( $expressionStack, $thisExpr2 );
		
		array_pop( $operatorStack );
	}

	
	$tempExpr2 = array_pop( $expressionStack2 );
	$tempExpr = array_pop( $expressionStack );
	
	return array( "result" => $tempExpr2 . $tempExpr, "position" => $i - 1 );

}

function parseFactor( $factor )
{
	if ( array_key_exists( "operator", $factor ) )
	{
		$factor1 = parseFactor( $factor["factor1"] );
		$factor2 = parseFactor( $factor["factor2"] );
		
		return $factor["operator"] . " ( " . $factor1 . ", " . $factor2 . " ) ";
	}
	else
	{
		return $factor["result"];
	}
}

function fetchFactor( $tokens, $start )
{
	if ( $tokens[ $start ]["type"] == TOKEN_STATE_STRING )
	{
		$myReturnValue = '"' . $tokens[ $start ]["value"] . '"';
	}
	else
	{
		if ( is_numeric ( $tokens[ $start ]["value"] ) )
			$myReturnValue = $tokens[ $start ]["value"];
		else
			$myReturnValue = $tokens[ $start ]["value"];
	}
	return array( "position" => $start + 2, "result" => $myReturnValue );
}

function fetchContainer( $tokens, $start )
{
	return array( "position" => $start+1, "result" => $tokens[ $start ]["value"] );
}

function compile( $script )
{
	
	$source = "";

	
	$script = explode( "\n", $script );
	
	$source  .= "/* Generated By HyperPHP */\n\n";
	
	foreach ( $script as $scriptLine )
	{
		$source .= "\n// " . $scriptLine . "\n" .  compileLine( tokenize( $scriptLine ) );
	}
	
	return str_replace( "\r", "", str_replace( "\n", "\\n", str_replace( "\"", "\\\"", $source ) ) );
	
}


?>